/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core.service;

import java.rmi.Naming;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Category;
import org.exolab.core.service.Service;
import org.exolab.core.service.ServiceException;
import org.exolab.jmscts.core.ExecutionListener;
import org.exolab.jmscts.core.service.ExecutionMonitorServer;

public class ExecutionMonitorService
extends Service {
    public static final String NAME = "ExecutionMonitorService";
    private static ExecutionMonitorService _instance = null;
    private HashMap _listeners = new HashMap();
    private ExecutionMonitorServer _server = null;
    private String _name = null;
    private static final Category log = Category.getInstance((Class)ExecutionMonitorService.class);

    protected ExecutionMonitorService(int port) {
        super(NAME);
        this._name = "//localhost:" + port + "/ExecutionListener";
    }

    public static synchronized ExecutionMonitorService initialise(int port) {
        if (_instance != null) {
            throw new IllegalStateException("ExecutionMonitorService has already been initialised");
        }
        _instance = new ExecutionMonitorService(port);
        return _instance;
    }

    public static synchronized ExecutionMonitorService instance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(String id, ExecutionListener listener) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 'id' is null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Argument 'listener' is null");
        }
        HashMap hashMap = this._listeners;
        synchronized (hashMap) {
            ArrayList<ExecutionListener> listeners = (ArrayList<ExecutionListener>)this._listeners.get(id);
            if (listeners == null) {
                listeners = new ArrayList<ExecutionListener>();
                this._listeners.put(id, listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(String id, ExecutionListener listener) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 'id' is null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Argument 'listener' is null");
        }
        HashMap hashMap = this._listeners;
        synchronized (hashMap) {
            ArrayList listeners = (ArrayList)this._listeners.get(id);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this._listeners.remove(id);
                }
            }
        }
    }

    public void failed(String id, Throwable throwable) {
        ExecutionListener[] listeners = this.getListeners(id);
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].failed(throwable);
            }
        } else {
            log.debug((Object)("Application=" + id + " failed to start but no " + "listeners are registered"), throwable);
        }
    }

    public void started(String id) {
        ExecutionListener[] listeners = this.getListeners(id);
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].started();
            }
        } else {
            log.debug((Object)("Application=" + id + " started but no " + "listeners are registered"));
        }
    }

    public void stopped(String id, int status) {
        ExecutionListener[] listeners = this.getListeners(id);
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].stopped(status);
            }
        } else {
            log.debug((Object)("Application=" + id + " stopped with status=" + status + " but no listeners are registered"));
        }
    }

    public void error(String id, Throwable throwable) {
        ExecutionListener[] listeners = this.getListeners(id);
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].failed(throwable);
            }
        } else {
            log.debug((Object)("Application=" + id + " threw exception " + " but no listeners are registered"));
        }
    }

    public String allocateId() {
        return new UID().toString();
    }

    public synchronized void start() throws ServiceException {
        if (!this.getState().isRunning()) {
            try {
                this._server = new ExecutionMonitorServer();
                Naming.bind(this._name, this._server);
            }
            catch (Exception exception) {
                throw new ServiceException(exception.getMessage());
            }
        }
        super.start();
    }

    public synchronized void stop() throws ServiceException {
        super.stop();
        this._listeners.clear();
        try {
            Naming.unbind(this._name);
            ExecutionMonitorServer.unexportObject(this._server, true);
        }
        catch (Exception exception) {
            throw new ServiceException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutionListener[] getListeners(String id) {
        ExecutionListener[] result = null;
        HashMap hashMap = this._listeners;
        synchronized (hashMap) {
            ArrayList listeners = (ArrayList)this._listeners.get(id);
            if (listeners != null) {
                result = listeners.toArray(new ExecutionListener[0]);
            }
        }
        return result;
    }
}

