/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core.service;

import org.apache.log4j.Category;
import org.exolab.core.service.Service;
import org.exolab.core.service.ServiceException;
import org.exolab.core.service.ServiceState;
import org.exolab.jmscts.core.AsyncExecutor;
import org.exolab.jmscts.core.ExecutionListener;
import org.exolab.jmscts.core.service.MessengerServer;

public class MessengerService
extends Service
implements ExecutionListener {
    public static final String NAME = "MessengerService";
    private static MessengerService _instance = null;
    private int _port = 0;
    private String _name = null;
    private AsyncExecutor _executor = null;
    private static final Category log = Category.getInstance((Class)MessengerService.class);

    public MessengerService(int port) {
        super(NAME);
        this._port = port;
    }

    public synchronized void start() throws ServiceException {
        if (!this.getState().isRunning()) {
            try {
                String args = "-port " + this._port;
                this._executor = new AsyncExecutor(MessengerServer.class, args, this._port);
                this._executor.addListener(this);
                this._executor.run();
            }
            catch (Exception exception) {
                throw new ServiceException(exception.getMessage());
            }
        }
        super.start();
    }

    public synchronized void stop() throws ServiceException {
        super.stop();
        try {
            this._executor.stop();
        }
        catch (Exception exception) {
            throw new ServiceException(exception.getMessage());
        }
    }

    public void failed(Throwable throwable) {
        log.error((Object)"MessengerServer failed with error", throwable);
        this.setState(ServiceState.STOPPED);
        this._executor = null;
    }

    public void started() {
        log.debug((Object)"MessengerServer started");
    }

    public void stopped(int status) {
        log.debug((Object)"MessengerServer stopped");
        this.setState(ServiceState.STOPPED);
        this._executor = null;
    }

    public void error(Throwable throwable) {
        log.error((Object)"MessengerServer failed with error", throwable);
    }
}

