/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core.types;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class MessageType
implements Serializable {
    public static final int BYTESMESSAGE_TYPE = 0;
    public static final MessageType BYTESMESSAGE = new MessageType(0, "BytesMessage");
    public static final int MAPMESSAGE_TYPE = 1;
    public static final MessageType MAPMESSAGE = new MessageType(1, "MapMessage");
    public static final int OBJECTMESSAGE_TYPE = 2;
    public static final MessageType OBJECTMESSAGE = new MessageType(2, "ObjectMessage");
    public static final int STREAMMESSAGE_TYPE = 3;
    public static final MessageType STREAMMESSAGE = new MessageType(3, "StreamMessage");
    public static final int TEXTMESSAGE_TYPE = 4;
    public static final MessageType TEXTMESSAGE = new MessageType(4, "TextMessage");
    public static final int MESSAGE_TYPE = 5;
    public static final MessageType MESSAGE = new MessageType(5, "Message");
    private static Hashtable _memberTable = MessageType.init();
    private int type = -1;
    private String stringValue = null;

    private MessageType(int type, String value) {
        this.type = type;
        this.stringValue = value;
    }

    public static Enumeration enumerate() {
        return _memberTable.elements();
    }

    public int getType() {
        return this.type;
    }

    private static Hashtable init() {
        Hashtable<String, MessageType> members = new Hashtable<String, MessageType>();
        members.put("BytesMessage", BYTESMESSAGE);
        members.put("MapMessage", MAPMESSAGE);
        members.put("ObjectMessage", OBJECTMESSAGE);
        members.put("StreamMessage", STREAMMESSAGE);
        members.put("TextMessage", TEXTMESSAGE);
        members.put("Message", MESSAGE);
        return members;
    }

    public String toString() {
        return this.stringValue;
    }

    public static MessageType valueOf(String string) {
        Object obj = null;
        if (string != null) {
            obj = _memberTable.get(string);
        }
        if (obj == null) {
            String err = "'" + string + "' is not a valid MessageType";
            throw new IllegalArgumentException(err);
        }
        return obj;
    }
}

