/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.jms.asf;

import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import org.apache.log4j.Category;
import org.exolab.jmscts.jms.asf.BasicServerSession;

public class BasicServerSessionPool
implements ServerSessionPool {
    private final int _size;
    private Connection _connection;
    private boolean _transacted;
    private int _ackMode;
    private MessageListener _listener;
    private LinkedList _pool = new LinkedList();
    private boolean _closed = false;
    private static final Category log = Category.getInstance((Class)BasicServerSessionPool.class);

    public BasicServerSessionPool(int size, Connection connection, boolean transacted, int ackMode, MessageListener listener) throws JMSException {
        if (size < 1) {
            throw new IllegalArgumentException("Argument 'size' must be > 0");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Argument 'connection' is null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Argument 'listener' is null");
        }
        this._size = size;
        this._connection = connection;
        this._transacted = transacted;
        this._ackMode = ackMode;
        this._listener = new SingleThreadedListener(listener);
        for (int i = 0; i < this._size; ++i) {
            this._pool.add(this.create());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession getServerSession() throws JMSException {
        ServerSession session = null;
        LinkedList linkedList = this._pool;
        synchronized (linkedList) {
            while (session == null) {
                if (this._closed) {
                    throw new JMSException("Pool has been closed");
                }
                if (!this._pool.isEmpty()) {
                    session = (ServerSession)this._pool.removeFirst();
                    continue;
                }
                try {
                    this._pool.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        LinkedList linkedList = this._pool;
        synchronized (linkedList) {
            this._closed = true;
            while (!this._pool.isEmpty()) {
                BasicServerSession session = (BasicServerSession)this._pool.removeFirst();
                session.close();
            }
            this._pool.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release(BasicServerSession session) {
        LinkedList linkedList = this._pool;
        synchronized (linkedList) {
            if (this._closed) {
                try {
                    session.close();
                }
                catch (JMSException exception) {
                    log.error((Object)exception);
                }
            } else {
                this._pool.add(session);
                this._pool.notify();
            }
        }
    }

    protected ServerSession create() throws JMSException {
        QueueSession session = null;
        if (this._connection instanceof XAQueueConnection) {
            XAQueueSession xaSession = ((XAQueueConnection)this._connection).createXAQueueSession();
            session = xaSession.getQueueSession();
        } else if (this._connection instanceof XATopicConnection) {
            XATopicSession xaSession = ((XATopicConnection)this._connection).createXATopicSession();
            session = xaSession.getTopicSession();
        } else if (this._connection instanceof QueueConnection) {
            session = ((QueueConnection)this._connection).createQueueSession(this._transacted, this._ackMode);
        } else if (this._connection instanceof TopicConnection) {
            session = ((TopicConnection)this._connection).createTopicSession(this._transacted, this._ackMode);
        } else {
            throw new JMSException("Invalid connection: " + this._connection);
        }
        session.setMessageListener(this._listener);
        return new BasicServerSession(this, (Session)session);
    }

    static class SingleThreadedListener
    implements MessageListener {
        private MessageListener _listener;

        public SingleThreadedListener(MessageListener listener) {
            this._listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message message) {
            MessageListener messageListener = this._listener;
            synchronized (messageListener) {
                this._listener.onMessage(message);
            }
        }
    }
}

