/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.jms.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import org.exolab.jmscts.jms.message.BasicMessage;

public class BasicBytesMessage
extends BasicMessage
implements BytesMessage {
    private static final byte[] EMPTY = new byte[0];
    private byte[] _bytes = EMPTY;
    private DataOutputStream _out = null;
    private ByteArrayOutputStream _byteOut = null;
    private DataInputStream _in = null;
    private ByteArrayInputStream _byteIn = null;
    private int _offset = 0;

    public boolean readBoolean() throws JMSException {
        boolean result = false;
        this.prepare();
        try {
            result = this._in.readBoolean();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public byte readByte() throws JMSException {
        byte result = 0;
        this.prepare();
        try {
            result = this._in.readByte();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public int readUnsignedByte() throws JMSException {
        int result = 0;
        this.prepare();
        try {
            result = this._in.readUnsignedByte();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public short readShort() throws JMSException {
        short result = 0;
        this.prepare();
        try {
            result = this._in.readShort();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public int readUnsignedShort() throws JMSException {
        int result = 0;
        this.prepare();
        try {
            result = this._in.readUnsignedShort();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public char readChar() throws JMSException {
        char result = '\u0000';
        this.prepare();
        try {
            result = this._in.readChar();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public int readInt() throws JMSException {
        int result = 0;
        this.prepare();
        try {
            result = this._in.readInt();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public long readLong() throws JMSException {
        long result = 0L;
        this.prepare();
        try {
            result = this._in.readLong();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public float readFloat() throws JMSException {
        float result = 0.0f;
        this.prepare();
        try {
            result = this._in.readFloat();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public double readDouble() throws JMSException {
        double result = 0.0;
        this.prepare();
        try {
            result = this._in.readDouble();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public String readUTF() throws JMSException {
        String result = null;
        this.prepare();
        try {
            result = this._in.readUTF();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        int read = -1;
        this.prepare();
        if (length < 0 || length > value.length) {
            throw new IndexOutOfBoundsException("Length must be > 0 and less than array size");
        }
        try {
            this._in.mark(length);
            int remain = this._in.available();
            if (remain == 0) {
                read = -1;
            } else if (length <= remain) {
                read = length;
                this._in.read(value, 0, length);
            } else {
                this._in.readFully(value, 0, remain);
                read = remain;
            }
        }
        catch (EOFException ignore) {
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return read;
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeBoolean(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeByte(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void writeShort(short value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeShort(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void writeChar(char value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeChar(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void writeInt(int value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeInt(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void writeLong(long value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeLong(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeFloat(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeDouble(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeUTF(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().write(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().write(value, offset, length);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF((String)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            if (value == null) {
                throw new NullPointerException("BytesMessage does not support null");
            }
            throw new MessageFormatException("Cannot write objects of type=" + value.getClass().getName());
        }
    }

    public void reset() throws JMSException {
        try {
            if (!this.getBodyReadOnly()) {
                this.setBodyReadOnly(true);
                if (this._out != null) {
                    this._out.flush();
                    this._bytes = this._byteOut.toByteArray();
                    this._byteOut = null;
                    this._out.close();
                    this._out = null;
                }
            } else if (this._in != null) {
                this._byteIn = null;
                this._in.close();
                this._in = null;
            }
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void clearBody() throws JMSException {
        try {
            if (this.getBodyReadOnly()) {
                this.setBodyReadOnly(false);
                if (this._in != null) {
                    this._byteIn = null;
                    this._in.close();
                    this._in = null;
                    this._offset = 0;
                }
            } else if (this._out != null) {
                this._byteOut = null;
                this._out.close();
                this._out = null;
            }
            this._bytes = EMPTY;
            this._byteOut = null;
            this._out = null;
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public void setReadOnly(boolean readOnly) throws JMSException {
        super.setReadOnly(readOnly);
        if (readOnly) {
            this.reset();
        }
    }

    private void prepare() throws JMSException {
        this.checkRead();
        this.getInputStream();
        try {
            this._in.mark(this._bytes.length - this._in.available());
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    private void revert(IOException exception) throws JMSException {
        try {
            this._in.reset();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        Object error = null;
        error = exception instanceof EOFException ? new MessageEOFException(exception.getMessage()) : (exception instanceof UTFDataFormatException ? new MessageFormatException(exception.getMessage()) : new JMSException(exception.getMessage()));
        error.setLinkedException((Exception)exception);
        throw error;
    }

    private DataInputStream getInputStream() {
        if (this._in == null) {
            this._byteIn = new ByteArrayInputStream(this._bytes, this._offset, this._bytes.length - this._offset);
            this._in = new DataInputStream(this._byteIn);
        }
        return this._in;
    }

    private DataOutputStream getOutputStream() throws IOException {
        if (this._out == null) {
            this._byteOut = new ByteArrayOutputStream();
            this._out = new DataOutputStream(this._byteOut);
            this._out.write(this._bytes);
        }
        return this._out;
    }

    private void raise(IOException exception) throws JMSException {
        JMSException error = new JMSException(exception.getMessage());
        error.setLinkedException((Exception)exception);
        throw error;
    }
}

