/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.jms.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import org.exolab.jmscts.jms.message.BasicMessage;

public class BasicObjectMessage
extends BasicMessage
implements ObjectMessage {
    private byte[] _bytes = null;

    public final void setObject(Serializable object) throws MessageFormatException, MessageNotWriteableException {
        this.checkWrite();
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(object);
            out.flush();
            this._bytes = byteOut.toByteArray();
            out.close();
        }
        catch (IOException exception) {
            MessageFormatException error = new MessageFormatException(exception.getMessage());
            error.setLinkedException((Exception)exception);
            throw error;
        }
    }

    public final Serializable getObject() throws MessageFormatException {
        Serializable result = null;
        if (this._bytes != null) {
            try {
                ByteArrayInputStream byteIn = new ByteArrayInputStream(this._bytes);
                ObjectInputStream in = new ObjectInputStream(byteIn);
                result = (Serializable)in.readObject();
                in.close();
            }
            catch (IOException exception) {
                MessageFormatException error = new MessageFormatException(exception.getMessage());
                error.setLinkedException((Exception)exception);
                throw error;
            }
            catch (ClassNotFoundException exception) {
                MessageFormatException error = new MessageFormatException(exception.getMessage());
                error.setLinkedException((Exception)exception);
                throw error;
            }
        }
        return result;
    }

    public final void clearBody() throws JMSException {
        super.clearBody();
        this._bytes = null;
    }
}

