/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.jms.message;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;
import org.exolab.jmscts.jms.message.BasicMessage;
import org.exolab.jmscts.jms.message.FormatConverter;

public class BasicStreamMessage
extends BasicMessage
implements StreamMessage {
    private List _body = new ArrayList();
    private int _index = 0;
    private byte[] _bytes;
    private int _bytesRead = 0;

    public boolean readBoolean() throws JMSException {
        boolean result = FormatConverter.getBoolean(this.readNext());
        ++this._index;
        return result;
    }

    public byte readByte() throws JMSException {
        byte result = FormatConverter.getByte(this.readNext());
        ++this._index;
        return result;
    }

    public short readShort() throws JMSException {
        short result = FormatConverter.getShort(this.readNext());
        ++this._index;
        return result;
    }

    public char readChar() throws JMSException {
        char result = FormatConverter.getChar(this.readNext());
        ++this._index;
        return result;
    }

    public int readInt() throws JMSException {
        int result = FormatConverter.getInt(this.readNext());
        ++this._index;
        return result;
    }

    public long readLong() throws JMSException {
        long result = FormatConverter.getLong(this.readNext());
        ++this._index;
        return result;
    }

    public float readFloat() throws JMSException {
        float result = FormatConverter.getFloat(this.readNext());
        ++this._index;
        return result;
    }

    public double readDouble() throws JMSException {
        double result = FormatConverter.getDouble(this.readNext());
        ++this._index;
        return result;
    }

    public String readString() throws JMSException {
        String result = FormatConverter.getString(this.readNext());
        ++this._index;
        return result;
    }

    public int readBytes(byte[] value) throws JMSException {
        int available;
        int read = 0;
        if (this._bytes == null) {
            Object next = this.readNext();
            if (!(next instanceof byte[])) {
                throw new MessageFormatException("Field is not a byte array");
            }
            this._bytes = (byte[])next;
            this._bytesRead = 0;
            ++this._index;
        }
        if ((available = this._bytes.length - this._bytesRead) == 0) {
            if (this._bytesRead != 0) {
                read = -1;
            }
        } else {
            read = value.length <= available ? value.length : available;
            System.arraycopy(this._bytes, this._bytesRead, value, 0, value.length);
            this._bytesRead += read;
        }
        return read;
    }

    public Object readObject() throws JMSException {
        Object result = this.readNext();
        ++this._index;
        return result;
    }

    public void writeBoolean(boolean value) throws MessageNotWriteableException {
        this.checkWrite();
        this._body.add(new Boolean(value));
    }

    public void writeByte(byte value) throws MessageNotWriteableException {
        this.checkWrite();
        this._body.add(new Byte(value));
    }

    public void writeShort(short value) throws MessageNotWriteableException {
        this.checkWrite();
        this._body.add(new Short(value));
    }

    public void writeChar(char value) throws MessageNotWriteableException {
        this.checkWrite();
        this._body.add(new Character(value));
    }

    public void writeInt(int value) throws MessageNotWriteableException {
        this.checkWrite();
        this._body.add(new Integer(value));
    }

    public void writeLong(long value) throws MessageNotWriteableException {
        this.checkWrite();
        this._body.add(new Long(value));
    }

    public void writeFloat(float value) throws MessageNotWriteableException {
        this.checkWrite();
        this._body.add(new Float(value));
    }

    public void writeDouble(double value) throws MessageNotWriteableException {
        this.checkWrite();
        this._body.add(new Double(value));
    }

    public void writeString(String value) throws MessageNotWriteableException {
        this.checkWrite();
        this._body.add(value);
    }

    public void writeBytes(byte[] value) throws MessageNotWriteableException {
        this.writeBytes(value, 0, value.length);
    }

    public void writeBytes(byte[] value, int offset, int length) throws MessageNotWriteableException {
        this.checkWrite();
        byte[] buffer = new byte[length];
        System.arraycopy(value, offset, buffer, 0, length);
        this._body.add(buffer);
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            this.checkWrite();
            this._body.add(null);
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeString((String)value);
        } else {
            throw new MessageFormatException("Objects of type " + value.getClass().getName() + " are not supported by StreamMessage");
        }
    }

    public void reset() {
        this.setBodyReadOnly(true);
        this._index = 0;
        this._bytes = null;
        this._bytesRead = 0;
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this._body.clear();
        this._index = 0;
        this._bytes = null;
        this._bytesRead = 0;
    }

    public void setReadOnly(boolean readOnly) throws JMSException {
        super.setReadOnly(readOnly);
        if (readOnly) {
            this.reset();
        }
    }

    private Object readNext() throws JMSException {
        this.checkRead();
        if (this._bytesRead != 0) {
            throw new MessageFormatException("Cannot read the next field until the byte array is read");
        }
        if (this._index == this._body.size()) {
            throw new MessageEOFException("End of stream");
        }
        return this._body.get(this._index);
    }
}

