/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.provider;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import org.exolab.jmscts.provider.Paths;
import org.exolab.jmscts.provider.Provider;

public class ProviderLoader {
    private String _name;
    private String _className;
    private boolean _start;
    private boolean _stop;
    private Paths _paths;
    private Provider _provider;

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public String getClassName() {
        return this._className;
    }

    public void setStart(boolean start) {
        this._start = start;
    }

    public boolean getStart() {
        return this._start;
    }

    public void setStop(boolean stop) {
        this._stop = stop;
    }

    public boolean getStop() {
        return this._stop;
    }

    public void setPaths(Paths paths) {
        this._paths = paths;
    }

    public Paths getPaths() {
        return this._paths;
    }

    public void setProvider(Provider provider) {
        this._provider = provider;
    }

    public Provider getProvider() {
        return this._provider;
    }

    public Provider createProvider() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterator iterator = this._paths.getPaths().iterator();
        while (iterator.hasNext()) {
            String path = (String)iterator.next();
            urls.add(this.getURL(path));
        }
        URL[] list = urls.toArray(new URL[0]);
        URLClassLoader loader = new URLClassLoader(list);
        Class<?> clazz = loader.loadClass(this._className);
        return (Provider)clazz.newInstance();
    }

    private URL getURL(String path) throws IOException {
        URL url;
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = file.getCanonicalFile();
        }
        if (file.exists() && file.canRead()) {
            url = file.toURL();
        } else {
            url = new URL(path);
            if (url.getProtocol().equals("file") && (file = new File(url.getFile())).exists() && file.canRead() && file.isDirectory()) {
                url = file.getCanonicalFile().toURL();
            }
        }
        return url;
    }
}

