/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.report;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Coverage
implements Serializable {
    private int _runs;
    private boolean _has_runs;
    private int _failures;
    private boolean _has_failures;
    private boolean _supported;
    private boolean _has_supported;
    private String _requirementId;
    private ArrayList _testList = new ArrayList();

    public void addTest(String vTest) throws IndexOutOfBoundsException {
        this._testList.add(vTest);
    }

    public void addTest(int index, String vTest) throws IndexOutOfBoundsException {
        this._testList.add(index, vTest);
    }

    public void clearTest() {
        this._testList.clear();
    }

    public void deleteSupported() {
        this._has_supported = false;
    }

    public Enumeration enumerateTest() {
        return new IteratorEnumeration(this._testList.iterator());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Coverage) {
            Coverage temp = (Coverage)obj;
            if (this._runs != temp._runs) {
                return false;
            }
            if (this._has_runs != temp._has_runs) {
                return false;
            }
            if (this._failures != temp._failures) {
                return false;
            }
            if (this._has_failures != temp._has_failures) {
                return false;
            }
            if (this._supported != temp._supported) {
                return false;
            }
            if (this._has_supported != temp._has_supported) {
                return false;
            }
            if (this._requirementId != null) {
                if (temp._requirementId == null) {
                    return false;
                }
                if (!this._requirementId.equals(temp._requirementId)) {
                    return false;
                }
            } else if (temp._requirementId != null) {
                return false;
            }
            if (this._testList != null) {
                if (temp._testList == null) {
                    return false;
                }
                if (!this._testList.equals(temp._testList)) {
                    return false;
                }
            } else if (temp._testList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int getFailures() {
        return this._failures;
    }

    public String getRequirementId() {
        return this._requirementId;
    }

    public int getRuns() {
        return this._runs;
    }

    public boolean getSupported() {
        return this._supported;
    }

    public String getTest(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._testList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (String)this._testList.get(index);
    }

    public String[] getTest() {
        int size = this._testList.size();
        String[] mArray = new String[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (String)this._testList.get(index);
        }
        return mArray;
    }

    public int getTestCount() {
        return this._testList.size();
    }

    public boolean hasFailures() {
        return this._has_failures;
    }

    public boolean hasRuns() {
        return this._has_runs;
    }

    public boolean hasSupported() {
        return this._has_supported;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeTest(String vTest) {
        boolean removed = this._testList.remove(vTest);
        return removed;
    }

    public void setFailures(int failures) {
        this._failures = failures;
        this._has_failures = true;
    }

    public void setRequirementId(String requirementId) {
        this._requirementId = requirementId;
    }

    public void setRuns(int runs) {
        this._runs = runs;
        this._has_runs = true;
    }

    public void setSupported(boolean supported) {
        this._supported = supported;
        this._has_supported = true;
    }

    public void setTest(int index, String vTest) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._testList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._testList.set(index, vTest);
    }

    public void setTest(String[] testArray) {
        this._testList.clear();
        for (int i = 0; i < testArray.length; ++i) {
            this._testList.add(testArray[i]);
        }
    }

    public static Coverage unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Coverage)Unmarshaller.unmarshal((Class)Coverage.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

