/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.report;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.exolab.jmscts.core.TestCoverage;
import org.exolab.jmscts.provider.ProviderLoader;
import org.exolab.jmscts.report.RequirementCoverage;
import org.exolab.jmscts.report.TransformerHelper;

public class CoverageReport {
    private String _path;
    private TestCoverage _coverage;
    private ProviderLoader _provider;
    private static final Category log = Category.getInstance((Class)CoverageReport.class);
    private static final String COVERAGE_XML = "coverage.xml";
    private static final String COVERAGE_STYLESHEET = "resources/coverage.xsl";
    private static final String COVERAGE_XDOC = "coverage.xml";

    public CoverageReport(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 'path' is null");
        }
        this._path = path;
    }

    public CoverageReport(String path, TestCoverage coverage, ProviderLoader provider) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 'path' is null");
        }
        if (coverage == null) {
            throw new IllegalArgumentException("Argument 'coverage' is null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 'provider' is null");
        }
        this._path = path;
        this._coverage = coverage;
        this._provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(String dir) throws IOException, MarshalException, TransformerException, ValidationException {
        if (this._coverage != null) {
            RequirementCoverage coverage = this._coverage.getCoverage();
            coverage.setProvider(this._provider.getName());
            String path = dir + "/" + "coverage.xml";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Writing coverage report to " + path));
            }
            FileWriter stream = new FileWriter(path);
            try {
                coverage.marshal(stream);
            }
            finally {
                stream.close();
            }
        }
        this.transform(dir);
    }

    private void transform(String dir) throws IOException, TransformerException {
        File input = new File(dir, "coverage.xml");
        File xdocs = new File(dir, "xdocs");
        if (!xdocs.exists() && !xdocs.mkdir()) {
            throw new IOException("Directory " + xdocs + " could not be created");
        }
        File html = new File(dir, "html");
        if (!html.exists() && !html.mkdir()) {
            throw new IOException("Directory " + html + " could not be created");
        }
        File coverageXdoc = new File(xdocs, "coverage.xml");
        File stylesheet = new File(this._path, COVERAGE_STYLESHEET);
        TransformerHelper.transform(input, coverageXdoc, stylesheet);
        TransformerHelper.transformAllXDoc2HTML(xdocs, html, new File(this._path));
    }

    public static void main(String[] args) throws Exception {
        String path = "path";
        Options options = new Options();
        options.addOption("path", true, "the output path");
        GnuParser parser = new GnuParser();
        CommandLine commands = parser.parse(options, args);
        String dir = commands.getOptionValue("path");
        if (dir == null) {
            throw new Exception("-path <path> parameter not set");
        }
        CoverageReport report = new CoverageReport("./");
        report.report(dir);
    }
}

