/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.report;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.exolab.jmscts.core.AckType;
import org.exolab.jmscts.core.JMSTestCase;
import org.exolab.jmscts.core.MessagingBehaviour;
import org.exolab.jmscts.core.ReceiptType;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.types.DeliveryModeType;
import org.exolab.jmscts.core.types.DestinationType;
import org.exolab.jmscts.core.types.FactoryType;
import org.exolab.jmscts.core.types.MessageType;
import org.exolab.jmscts.core.types.ReceiverType;
import org.exolab.jmscts.core.types.SessionType;
import org.exolab.jmscts.report.Behaviour;
import org.exolab.jmscts.report.Cause;
import org.exolab.jmscts.report.Context;
import org.exolab.jmscts.report.Factory;
import org.exolab.jmscts.report.Failure;
import org.exolab.jmscts.report.RootCause;
import org.exolab.jmscts.report.TestRun;
import org.exolab.jmscts.report.TestRuns;

public final class ReportHelper {
    private ReportHelper() {
    }

    public static TestRuns getTestRuns(JMSTestCase test) {
        TestRuns result = new TestRuns();
        result.setTest(ReportHelper.getName(test));
        return result;
    }

    public static TestRun getTestRun(JMSTestCase test) {
        return ReportHelper.getTestRun(test, test.getContext());
    }

    public static TestRun getTestRun(JMSTestCase test, TestContext context) {
        TestRun result = new TestRun();
        if (context != null) {
            result.setContext(ReportHelper.getContext(context));
        }
        return result;
    }

    public static Failure getFailure(Throwable cause, Throwable rootCause) {
        String description = cause.getMessage();
        if (description == null) {
            description = cause.getClass().getName();
        }
        return ReportHelper.getFailure(description, cause, rootCause);
    }

    public static Failure getFailure(String description, Throwable cause, Throwable rootCause) {
        Failure failure = new Failure();
        failure.setDescription(description);
        Cause reason = new Cause();
        reason.addAnyObject(ReportHelper.getStackTrace(cause));
        failure.setCause(reason);
        if (rootCause != null) {
            RootCause rootReason = new RootCause();
            rootReason.addAnyObject(ReportHelper.getStackTrace(rootCause));
            failure.setRootCause(rootReason);
        }
        return failure;
    }

    public static String getName(JMSTestCase test) {
        return test.getClass().getName() + "." + test.getName();
    }

    public static Context getContext(TestContext context) {
        Context result = new Context();
        result.setFactory(ReportHelper.getFactory(context));
        result.setSession(ReportHelper.getSession(context));
        result.setMessage(ReportHelper.getMessage(context));
        result.setBehaviour(ReportHelper.getBehaviour(context));
        return result;
    }

    public static Factory getFactory(TestContext context) {
        Factory result = new Factory();
        if (context.isQueueConnectionFactory()) {
            result.setType(FactoryType.QUEUECONNECTIONFACTORY);
        } else if (context.isTopicConnectionFactory()) {
            result.setType(FactoryType.TOPICCONNECTIONFACTORY);
        } else if (context.isXAQueueConnectionFactory()) {
            result.setType(FactoryType.XAQUEUECONNECTIONFACTORY);
        } else {
            result.setType(FactoryType.XATOPICCONNECTIONFACTORY);
        }
        return result;
    }

    public static SessionType getSession(TestContext context) {
        SessionType result = null;
        AckType ack = context.getAckType();
        if (ack != null) {
            if (ack.getTransacted()) {
                result = SessionType.TRANSACTED;
            } else {
                switch (ack.getAcknowledgeMode()) {
                    case 1: {
                        result = SessionType.AUTO_ACKNOWLEDGE;
                        break;
                    }
                    case 2: {
                        result = SessionType.CLIENT_ACKNOWLEDGE;
                        break;
                    }
                    default: {
                        result = SessionType.DUPS_OK_ACKNOWLEDGE;
                    }
                }
            }
        }
        return result;
    }

    public static MessageType getMessage(TestContext context) {
        MessageType result = null;
        Class type = context.getMessageType();
        if (type != null) {
            if (type == BytesMessage.class) {
                result = MessageType.BYTESMESSAGE;
            } else if (type == MapMessage.class) {
                result = MessageType.MAPMESSAGE;
            } else if (type == ObjectMessage.class) {
                result = MessageType.OBJECTMESSAGE;
            } else if (type == StreamMessage.class) {
                result = MessageType.STREAMMESSAGE;
            } else if (type == TextMessage.class) {
                result = MessageType.TEXTMESSAGE;
            } else if (type == Message.class) {
                result = MessageType.MESSAGE;
            }
        }
        return result;
    }

    public static Behaviour getBehaviour(TestContext context) {
        Behaviour result = null;
        MessagingBehaviour behaviour = context.getMessagingBehaviour();
        if (behaviour != null) {
            result = new Behaviour();
            if (behaviour.getDeliveryMode() == 2) {
                result.setDeliveryMode(DeliveryModeType.PERSISTENT);
            } else {
                result.setDeliveryMode(DeliveryModeType.NON_PERSISTENT);
            }
            ReceiptType receipt = behaviour.getReceiptType();
            if (ReceiptType.SYNCHRONOUS.equals(receipt)) {
                if (behaviour.getDurable()) {
                    result.setReceiver(ReceiverType.DURABLE_SYNCHRONOUS);
                } else {
                    result.setReceiver(ReceiverType.SYNCHRONOUS);
                }
            } else if (ReceiptType.ASYNCHRONOUS.equals(receipt)) {
                if (behaviour.getDurable()) {
                    result.setReceiver(ReceiverType.DURABLE_ASYNCHRONOUS);
                } else {
                    result.setReceiver(ReceiverType.ASYNCHRONOUS);
                }
            } else if (ReceiptType.BROWSER.equals(receipt)) {
                result.setReceiver(ReceiverType.BROWSER);
            }
            if (behaviour.getAdministered()) {
                result.setDestination(DestinationType.ADMINISTERED);
            } else {
                result.setDestination(DestinationType.TEMPORARY);
            }
        }
        return result;
    }

    private static String getStackTrace(Throwable error) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(stream);
        error.printStackTrace(print);
        print.flush();
        String result = stream.toString();
        return result;
    }
}

