/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.report;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.jmscts.report.Coverage;
import org.exolab.jmscts.report.CurrentTest;
import org.exolab.jmscts.report.Failure;
import org.exolab.jmscts.report.TestRuns;
import org.xml.sax.ContentHandler;

public class RequirementCoverage
implements Serializable {
    private String _provider;
    private CurrentTest _currentTest;
    private ArrayList _coverageList = new ArrayList();
    private ArrayList _testRunsList = new ArrayList();
    private ArrayList _failureList = new ArrayList();

    public void addCoverage(Coverage vCoverage) throws IndexOutOfBoundsException {
        this._coverageList.add(vCoverage);
    }

    public void addCoverage(int index, Coverage vCoverage) throws IndexOutOfBoundsException {
        this._coverageList.add(index, vCoverage);
    }

    public void addFailure(Failure vFailure) throws IndexOutOfBoundsException {
        this._failureList.add(vFailure);
    }

    public void addFailure(int index, Failure vFailure) throws IndexOutOfBoundsException {
        this._failureList.add(index, vFailure);
    }

    public void addTestRuns(TestRuns vTestRuns) throws IndexOutOfBoundsException {
        this._testRunsList.add(vTestRuns);
    }

    public void addTestRuns(int index, TestRuns vTestRuns) throws IndexOutOfBoundsException {
        this._testRunsList.add(index, vTestRuns);
    }

    public void clearCoverage() {
        this._coverageList.clear();
    }

    public void clearFailure() {
        this._failureList.clear();
    }

    public void clearTestRuns() {
        this._testRunsList.clear();
    }

    public Enumeration enumerateCoverage() {
        return new IteratorEnumeration(this._coverageList.iterator());
    }

    public Enumeration enumerateFailure() {
        return new IteratorEnumeration(this._failureList.iterator());
    }

    public Enumeration enumerateTestRuns() {
        return new IteratorEnumeration(this._testRunsList.iterator());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RequirementCoverage) {
            RequirementCoverage temp = (RequirementCoverage)obj;
            if (this._provider != null) {
                if (temp._provider == null) {
                    return false;
                }
                if (!this._provider.equals(temp._provider)) {
                    return false;
                }
            } else if (temp._provider != null) {
                return false;
            }
            if (this._currentTest != null) {
                if (temp._currentTest == null) {
                    return false;
                }
                if (!this._currentTest.equals(temp._currentTest)) {
                    return false;
                }
            } else if (temp._currentTest != null) {
                return false;
            }
            if (this._coverageList != null) {
                if (temp._coverageList == null) {
                    return false;
                }
                if (!this._coverageList.equals(temp._coverageList)) {
                    return false;
                }
            } else if (temp._coverageList != null) {
                return false;
            }
            if (this._testRunsList != null) {
                if (temp._testRunsList == null) {
                    return false;
                }
                if (!this._testRunsList.equals(temp._testRunsList)) {
                    return false;
                }
            } else if (temp._testRunsList != null) {
                return false;
            }
            if (this._failureList != null) {
                if (temp._failureList == null) {
                    return false;
                }
                if (!this._failureList.equals(temp._failureList)) {
                    return false;
                }
            } else if (temp._failureList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Coverage getCoverage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._coverageList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Coverage)this._coverageList.get(index);
    }

    public Coverage[] getCoverage() {
        int size = this._coverageList.size();
        Coverage[] mArray = new Coverage[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Coverage)this._coverageList.get(index);
        }
        return mArray;
    }

    public int getCoverageCount() {
        return this._coverageList.size();
    }

    public CurrentTest getCurrentTest() {
        return this._currentTest;
    }

    public Failure getFailure(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._failureList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Failure)this._failureList.get(index);
    }

    public Failure[] getFailure() {
        int size = this._failureList.size();
        Failure[] mArray = new Failure[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Failure)this._failureList.get(index);
        }
        return mArray;
    }

    public int getFailureCount() {
        return this._failureList.size();
    }

    public String getProvider() {
        return this._provider;
    }

    public TestRuns getTestRuns(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._testRunsList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (TestRuns)this._testRunsList.get(index);
    }

    public TestRuns[] getTestRuns() {
        int size = this._testRunsList.size();
        TestRuns[] mArray = new TestRuns[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (TestRuns)this._testRunsList.get(index);
        }
        return mArray;
    }

    public int getTestRunsCount() {
        return this._testRunsList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeCoverage(Coverage vCoverage) {
        boolean removed = this._coverageList.remove(vCoverage);
        return removed;
    }

    public boolean removeFailure(Failure vFailure) {
        boolean removed = this._failureList.remove(vFailure);
        return removed;
    }

    public boolean removeTestRuns(TestRuns vTestRuns) {
        boolean removed = this._testRunsList.remove(vTestRuns);
        return removed;
    }

    public void setCoverage(int index, Coverage vCoverage) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._coverageList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._coverageList.set(index, vCoverage);
    }

    public void setCoverage(Coverage[] coverageArray) {
        this._coverageList.clear();
        for (int i = 0; i < coverageArray.length; ++i) {
            this._coverageList.add(coverageArray[i]);
        }
    }

    public void setCurrentTest(CurrentTest currentTest) {
        this._currentTest = currentTest;
    }

    public void setFailure(int index, Failure vFailure) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._failureList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._failureList.set(index, vFailure);
    }

    public void setFailure(Failure[] failureArray) {
        this._failureList.clear();
        for (int i = 0; i < failureArray.length; ++i) {
            this._failureList.add(failureArray[i]);
        }
    }

    public void setProvider(String provider) {
        this._provider = provider;
    }

    public void setTestRuns(int index, TestRuns vTestRuns) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._testRunsList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._testRunsList.set(index, vTestRuns);
    }

    public void setTestRuns(TestRuns[] testRunsArray) {
        this._testRunsList.clear();
        for (int i = 0; i < testRunsArray.length; ++i) {
            this._testRunsList.add(testRunsArray[i]);
        }
    }

    public static RequirementCoverage unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (RequirementCoverage)Unmarshaller.unmarshal((Class)RequirementCoverage.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

