/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.report;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.jmscts.report.Context;
import org.exolab.jmscts.report.Failure;
import org.exolab.jmscts.report.Statistic;
import org.xml.sax.ContentHandler;

public class TestRun
implements Serializable {
    private Context _context;
    private Failure _failure;
    private ArrayList _statisticList = new ArrayList();

    public void addStatistic(Statistic vStatistic) throws IndexOutOfBoundsException {
        this._statisticList.add(vStatistic);
    }

    public void addStatistic(int index, Statistic vStatistic) throws IndexOutOfBoundsException {
        this._statisticList.add(index, vStatistic);
    }

    public void clearStatistic() {
        this._statisticList.clear();
    }

    public Enumeration enumerateStatistic() {
        return new IteratorEnumeration(this._statisticList.iterator());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TestRun) {
            TestRun temp = (TestRun)obj;
            if (this._context != null) {
                if (temp._context == null) {
                    return false;
                }
                if (!this._context.equals(temp._context)) {
                    return false;
                }
            } else if (temp._context != null) {
                return false;
            }
            if (this._failure != null) {
                if (temp._failure == null) {
                    return false;
                }
                if (!this._failure.equals(temp._failure)) {
                    return false;
                }
            } else if (temp._failure != null) {
                return false;
            }
            if (this._statisticList != null) {
                if (temp._statisticList == null) {
                    return false;
                }
                if (!this._statisticList.equals(temp._statisticList)) {
                    return false;
                }
            } else if (temp._statisticList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Context getContext() {
        return this._context;
    }

    public Failure getFailure() {
        return this._failure;
    }

    public Statistic getStatistic(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._statisticList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Statistic)this._statisticList.get(index);
    }

    public Statistic[] getStatistic() {
        int size = this._statisticList.size();
        Statistic[] mArray = new Statistic[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Statistic)this._statisticList.get(index);
        }
        return mArray;
    }

    public int getStatisticCount() {
        return this._statisticList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeStatistic(Statistic vStatistic) {
        boolean removed = this._statisticList.remove(vStatistic);
        return removed;
    }

    public void setContext(Context context) {
        this._context = context;
    }

    public void setFailure(Failure failure) {
        this._failure = failure;
    }

    public void setStatistic(int index, Statistic vStatistic) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._statisticList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._statisticList.set(index, vStatistic);
    }

    public void setStatistic(Statistic[] statisticArray) {
        this._statisticList.clear();
        for (int i = 0; i < statisticArray.length; ++i) {
            this._statisticList.add(statisticArray[i]);
        }
    }

    public static TestRun unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (TestRun)Unmarshaller.unmarshal((Class)TestRun.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

