/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Category;

public final class TransformerHelper {
    private static final Category log = Category.getInstance((Class)TransformerHelper.class);
    private static final String XDOC_EXT = ".xml";
    private static final String HTML_EXT = ".html";
    private static final String XDOC_STYLESHEET = "resources/xdoc2html.xsl";

    private TransformerHelper() {
    }

    public static void transformXDoc2HTML(File inputPath, File outputPath, File baseDir) throws IOException, TransformerException {
        if (outputPath.isDirectory()) {
            String inputName = inputPath.getName();
            int length = inputName.length() - HTML_EXT.length() + 1;
            String outputName = inputName.substring(0, length) + HTML_EXT;
            outputPath = new File(outputPath, outputName);
        }
        File stylesheetPath = new File(baseDir, XDOC_STYLESHEET);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Transforming file " + inputPath + " using stylesheet " + stylesheetPath + " to " + outputPath));
        }
        Templates stylesheet = TransformerHelper.getStylesheet(stylesheetPath);
        TransformerHelper.transform(inputPath, outputPath, stylesheet, TransformerHelper.getProperties(baseDir));
    }

    public static void transformAllXDoc2HTML(File inputDir, File outputDir, File baseDir) throws IOException, TransformerException {
        String[] files;
        File stylesheetPath = new File(baseDir, XDOC_STYLESHEET);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Transforming directory " + inputDir + " using stylesheet " + stylesheetPath + " to " + outputDir));
        }
        if ((files = inputDir.list()) == null) {
            throw new IOException("Failed to list directory: " + inputDir);
        }
        Templates stylesheet = TransformerHelper.getStylesheet(stylesheetPath);
        HashMap properties = TransformerHelper.getProperties(baseDir);
        for (int i = 0; i < files.length; ++i) {
            String inputName = files[i];
            if (!inputName.endsWith(XDOC_EXT)) continue;
            File input = new File(inputDir, inputName);
            int length = inputName.length() - HTML_EXT.length() + 1;
            String outputName = inputName.substring(0, length) + HTML_EXT;
            File output = new File(outputDir, outputName);
            TransformerHelper.transform(input, output, stylesheet, properties);
        }
    }

    public static void transform(File inputPath, File outputPath, File stylesheetPath) throws IOException, TransformerException {
        Templates stylesheet = TransformerHelper.getStylesheet(stylesheetPath);
        TransformerHelper.transform(inputPath, outputPath, stylesheet, new HashMap());
    }

    public static void transform(File inputPath, File outputPath, Templates stylesheet, HashMap properties) throws IOException, TransformerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Transforming " + inputPath + " -> " + outputPath));
        }
        Transformer transformer = stylesheet.newTransformer();
        Iterator iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            transformer.setParameter(name, value);
        }
        transformer.transform(new StreamSource(inputPath), new StreamResult(new FileOutputStream(outputPath)));
    }

    public static Templates getStylesheet(File path) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Templates template = factory.newTemplates(new StreamSource(path));
        return template;
    }

    private static HashMap getProperties(File baseDir) throws IOException {
        File resourcesDir = new File(baseDir, "resources");
        HashMap<String, URL> properties = new HashMap<String, URL>();
        properties.put("style-path", resourcesDir.toURL());
        return properties;
    }
}

