/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.requirements;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.jmscts.requirements.Description;
import org.exolab.jmscts.requirements.RequirementChoice;
import org.xml.sax.ContentHandler;

public class Requirement
implements Serializable {
    private String _requirementId;
    private boolean _optional;
    private boolean _has_optional;
    private Description _description;
    private ArrayList _requirementChoiceList = new ArrayList();

    public void addRequirementChoice(RequirementChoice vRequirementChoice) throws IndexOutOfBoundsException {
        this._requirementChoiceList.add(vRequirementChoice);
    }

    public void addRequirementChoice(int index, RequirementChoice vRequirementChoice) throws IndexOutOfBoundsException {
        this._requirementChoiceList.add(index, vRequirementChoice);
    }

    public void clearRequirementChoice() {
        this._requirementChoiceList.clear();
    }

    public void deleteOptional() {
        this._has_optional = false;
    }

    public Enumeration enumerateRequirementChoice() {
        return new IteratorEnumeration(this._requirementChoiceList.iterator());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Requirement) {
            Requirement temp = (Requirement)obj;
            if (this._requirementId != null) {
                if (temp._requirementId == null) {
                    return false;
                }
                if (!this._requirementId.equals(temp._requirementId)) {
                    return false;
                }
            } else if (temp._requirementId != null) {
                return false;
            }
            if (this._optional != temp._optional) {
                return false;
            }
            if (this._has_optional != temp._has_optional) {
                return false;
            }
            if (this._description != null) {
                if (temp._description == null) {
                    return false;
                }
                if (!this._description.equals(temp._description)) {
                    return false;
                }
            } else if (temp._description != null) {
                return false;
            }
            if (this._requirementChoiceList != null) {
                if (temp._requirementChoiceList == null) {
                    return false;
                }
                if (!this._requirementChoiceList.equals(temp._requirementChoiceList)) {
                    return false;
                }
            } else if (temp._requirementChoiceList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Description getDescription() {
        return this._description;
    }

    public boolean getOptional() {
        return this._optional;
    }

    public RequirementChoice getRequirementChoice(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._requirementChoiceList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (RequirementChoice)this._requirementChoiceList.get(index);
    }

    public RequirementChoice[] getRequirementChoice() {
        int size = this._requirementChoiceList.size();
        RequirementChoice[] mArray = new RequirementChoice[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (RequirementChoice)this._requirementChoiceList.get(index);
        }
        return mArray;
    }

    public int getRequirementChoiceCount() {
        return this._requirementChoiceList.size();
    }

    public String getRequirementId() {
        return this._requirementId;
    }

    public boolean hasOptional() {
        return this._has_optional;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeRequirementChoice(RequirementChoice vRequirementChoice) {
        boolean removed = this._requirementChoiceList.remove(vRequirementChoice);
        return removed;
    }

    public void setDescription(Description description) {
        this._description = description;
    }

    public void setOptional(boolean optional) {
        this._optional = optional;
        this._has_optional = true;
    }

    public void setRequirementChoice(int index, RequirementChoice vRequirementChoice) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._requirementChoiceList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._requirementChoiceList.set(index, vRequirementChoice);
    }

    public void setRequirementChoice(RequirementChoice[] requirementChoiceArray) {
        this._requirementChoiceList.clear();
        for (int i = 0; i < requirementChoiceArray.length; ++i) {
            this._requirementChoiceList.add(requirementChoiceArray[i]);
        }
    }

    public void setRequirementId(String requirementId) {
        this._requirementId = requirementId;
    }

    public static Requirement unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Requirement)Unmarshaller.unmarshal((Class)Requirement.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

