/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.requirements;

import java.util.HashMap;
import org.exolab.castor.xml.ValidationException;
import org.exolab.jmscts.requirements.Reference;
import org.exolab.jmscts.requirements.Requirement;
import org.exolab.jmscts.requirements.RequirementChoice;
import org.exolab.jmscts.requirements.RequirementChoiceItem;

public class Requirements {
    private HashMap _requirements = new HashMap();
    private HashMap _references = new HashMap();
    private int _anonymousReference = 0;

    public Requirement getRequirement(String requirementId) {
        return (Requirement)this._requirements.get(requirementId);
    }

    public HashMap getRequirements() {
        return this._requirements;
    }

    public Reference getReference(String referenceId) {
        return (Reference)this._references.get(referenceId);
    }

    public void addRequirement(Requirement requirement) throws ValidationException {
        if (requirement == null) {
            throw new IllegalArgumentException("Argument requirement is null");
        }
        if (this._requirements.containsKey(requirement.getRequirementId())) {
            throw new ValidationException("Duplicate requirement: " + requirement.getRequirementId());
        }
        RequirementChoice[] choices = requirement.getRequirementChoice();
        for (int i = 0; i < choices.length; ++i) {
            RequirementChoiceItem item = choices[i].getRequirementChoiceItem();
            if (item.getReference() != null) {
                this.addReference(item.getReference());
                continue;
            }
            if (this._references.containsKey(item.getReferenceId())) continue;
            throw new ValidationException("Requirement " + requirement.getRequirementId() + " has an unknown reference: " + item.getReferenceId());
        }
        this._requirements.put(requirement.getRequirementId(), requirement);
    }

    public void addReference(Reference reference) throws ValidationException {
        if (reference == null) {
            throw new IllegalArgumentException("Argument reference is null");
        }
        String referenceId = reference.getReferenceId();
        if (referenceId == null) {
            referenceId = "anonymous" + ++this._anonymousReference;
        } else if (this._references.containsKey(referenceId)) {
            throw new ValidationException("Duplicate reference: " + reference.getReferenceId());
        }
        this._references.put(referenceId, reference);
    }
}

