/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.stress;

import javax.jms.Message;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.AckType;
import org.exolab.jmscts.core.CountingListener;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.ReceiptType;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestContextHelper;
import org.exolab.jmscts.core.TestProperties;
import org.exolab.jmscts.core.TestStatistics;
import org.exolab.jmscts.core.ThreadedActions;
import org.exolab.jmscts.core.ThreadedReceiver;
import org.exolab.jmscts.core.ThreadedSender;
import org.exolab.jmscts.report.types.StatisticType;
import org.exolab.jmscts.stress.AckingListener;

public class SendReceiveStressTestCase
extends AbstractSendReceiveTestCase {
    private int _count;
    private final String _destination;
    private MessageSender _sender;
    private final int _receiverCount;
    private CountingListener _listener;
    private MessageReceiver[] _receivers;
    private TestContext[] _contexts;
    private static final Category log = Category.getInstance((Class)SendReceiveStressTestCase.class);

    public SendReceiveStressTestCase(String name, String destination, int receivers) {
        super(name);
        this._destination = destination;
        this._receiverCount = receivers;
    }

    protected void runStress() throws Exception {
        int defaultTimeout = 2000;
        long timeout = TestProperties.getInt(this.getClass(), "timeout", 2000);
        TestContext context = this.getContext();
        ThreadedActions receive = new ThreadedActions();
        for (int i = 0; i < this._receiverCount; ++i) {
            ThreadedReceiver action = new ThreadedReceiver(this._receivers[i], timeout, this._listener);
            receive.addAction(action);
        }
        TestStatistics stats = context.getStatistics();
        Message message = context.getMessage();
        ThreadedSender send = new ThreadedSender(this._sender, message, this._count);
        receive.start();
        send.run();
        receive.waitForCompletion();
        if (receive.getException() != null) {
            throw receive.getException();
        }
        if (send.getException() != null) {
            throw send.getException();
        }
        int expected = this._listener.getExpected();
        int received = this._listener.getReceived();
        SendReceiveStressTestCase.assertEquals((String)("Expected " + expected + " messages to be received, " + "but got " + received), (int)expected, (int)received);
        stats.log(StatisticType.SEND, this._count, send.getElapsedTime());
        stats.log(StatisticType.RECEIVE, this._count, receive.getElapsedTime());
    }

    protected void setUp() throws Exception {
        int defaultCount = 1000;
        this._count = TestProperties.getInt(this.getClass(), "count", 1000);
        TestContext context = this.getContext();
        this._sender = this.createSender(this._destination);
        this._receivers = new MessageReceiver[this._receiverCount];
        this._contexts = new TestContext[this._receiverCount];
        AckType ack = context.getAckType();
        ReceiptType receipt = context.getMessagingBehaviour().getReceiptType();
        int expected = context.isQueue() && !receipt.equals(ReceiptType.BROWSER) ? this._count : this._count * this._receiverCount;
        this._listener = ack.getAcknowledgeMode() == 2 && !receipt.equals(ReceiptType.BROWSER) ? new AckingListener(expected) : new CountingListener(expected);
        for (int i = 0; i < this._receiverCount; ++i) {
            MessageReceiver receiver;
            TestContext receiveContext;
            this._contexts[i] = receiveContext = TestContextHelper.createSendReceiveContext(context, false);
            this._receivers[i] = receiver = this.createReceiver(receiveContext, this._destination);
        }
    }

    protected void tearDown() throws Exception {
        this.close(this._sender);
        this.close(this._receivers);
        for (int i = 0; i < this._contexts.length; ++i) {
            TestContext context = this._contexts[i];
            if (context == null) continue;
            context.getSession().close();
        }
    }
}

