/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.connection;

import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Session;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractConnectionTestCase;
import org.exolab.jmscts.core.AckTypes;
import org.exolab.jmscts.core.ConnectionFactoryHelper;
import org.exolab.jmscts.core.ConnectionHelper;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class ClientIdentifierTest
extends AbstractConnectionTestCase {
    private static final String CLIENT_ID = "myClientID";
    private static final Category log = Category.getInstance((Class)ClientIdentifierTest.class);

    public ClientIdentifierTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createConnectionTest(ClientIdentifierTest.class);
    }

    public void testSetOnCreation() throws Exception {
        TestContext context = this.getContext();
        Connection connection = context.getConnection();
        try {
            connection.setClientID(CLIENT_ID);
        }
        catch (IllegalStateException exception) {
            context.getCoverage().setUnsupported("connection.clientID.administered");
        }
        catch (Exception exception) {
            String msg = "Expected IllegalStateException to be thrown if an administered client identifier exists for a connection, but got: " + exception.getClass().getName();
            log.debug((Object)msg, (Throwable)exception);
            ClientIdentifierTest.fail((String)msg);
        }
        this.expectFailure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDuplicateClientID() throws Exception {
        TestContext context = this.getContext();
        Connection first = context.getConnection();
        Connection second = null;
        boolean test = true;
        try {
            second = ConnectionFactoryHelper.createConnection(context, CLIENT_ID);
        }
        catch (IllegalStateException unsupported) {
            test = false;
        }
        if (test) {
            try {
                first.setClientID(CLIENT_ID);
                ClientIdentifierTest.fail((String)"Managed to set the same client identifier on two different connections");
            }
            catch (InvalidClientIDException expected) {
            }
            catch (Exception exception) {
                ClientIdentifierTest.fail((String)("Expected setClientID to throw , InvalidClientIDException but got: " + exception));
            }
            finally {
                second.close();
            }
            first.setClientID(CLIENT_ID);
        }
    }

    public void testSetAfterClose() throws Exception {
        Connection connection = this.getContext().getConnection();
        connection.close();
        this.expectFailure();
    }

    public void testSetAfterListenerRegistration() throws Exception {
        Connection connection = this.getContext().getConnection();
        connection.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException exception) {
            }
        });
        this.expectFailure();
    }

    public void testSetAfterStart() throws Exception {
        Connection connection = this.getContext().getConnection();
        connection.start();
        this.expectFailure();
    }

    public void testSetAfterStop() throws Exception {
        Connection connection = this.getContext().getConnection();
        connection.stop();
        this.expectFailure();
    }

    public void testSetAfterCreateSession() throws Exception {
        TestContext context = this.getContext();
        Session session = ConnectionHelper.createSession(context, AckTypes.AUTO_ACKNOWLEDGE);
        this.expectFailure();
    }

    public boolean startConnection() {
        return false;
    }

    private void expectFailure() throws Exception {
        try {
            this.getContext().getConnection().setClientID(CLIENT_ID);
            ClientIdentifierTest.fail((String)"setClientID should throw IllegalStateException");
        }
        catch (IllegalStateException expected) {
        }
        catch (Exception exception) {
            ClientIdentifierTest.fail((String)("Expected setClientID to throw IllegalStateException, but got: " + exception));
        }
    }
}

