/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.connection;

import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractConnectionTestCase;
import org.exolab.jmscts.core.MethodInvoker;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class ConnectionCloseTest
extends AbstractConnectionTestCase {
    private static final Category log = Category.getInstance((Class)ConnectionCloseTest.class);

    public ConnectionCloseTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createConnectionTest(ConnectionCloseTest.class);
    }

    public boolean share() {
        return false;
    }

    public void testExceptionOnClose() throws Exception {
        TestContext context = this.getContext();
        Connection connection = context.getConnection();
        MethodInvoker invoker = new MethodInvoker(context.getConnectionType(), IllegalStateException.class);
        ExceptionListener dummyListener = new ExceptionListener(){

            public void onException(JMSException exception) {
            }
        };
        connection.close();
        invoker.invoke((Object)connection, "getClientID");
        invoker.invoke((Object)connection, "getExceptionListener");
        invoker.invoke((Object)connection, "getMetaData");
        invoker.invoke((Object)connection, "setClientID", (Object)"dummyID");
        invoker.invoke((Object)connection, "setExceptionListener", (Object)dummyListener);
        invoker.invoke((Object)connection, "start");
        invoker.invoke((Object)connection, "stop");
        Object[] args = new Object[]{Boolean.TRUE, new Integer(0)};
        if (context.isQueueConnectionFactory()) {
            invoker.invoke((Object)connection, "createQueueSession", args);
        } else if (context.isTopicConnectionFactory()) {
            invoker.invoke((Object)connection, "createTopicSession", args);
        } else if (context.isXAQueueConnectionFactory()) {
            invoker.invoke((Object)connection, "createQueueSession", args);
            invoker.invoke((Object)connection, "createXAQueueSession");
        } else {
            invoker.invoke((Object)connection, "createTopicSession", args);
            invoker.invoke((Object)connection, "createXATopicSession");
        }
    }

    public void testCloseForClosedConnection() throws Exception {
        TestContext context = this.getContext();
        Connection connection = context.getConnection();
        connection.close();
        try {
            connection.close();
        }
        catch (Exception exception) {
            String msg = "Closing a closed connection shouldn't generate an exception";
            log.debug((Object)msg, (Throwable)exception);
            ConnectionCloseTest.fail((String)msg);
        }
    }
}

