/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.connection;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.DelayedAction;
import org.exolab.jmscts.core.EchoListener;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.SessionHelper;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestContextHelper;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.core.WaitingListener;

public class ListenerTest
extends AbstractSendReceiveTestCase {
    private static final String REQUEST = "requestClose";
    private static final String REPLY = "replyClose";
    private static final String[] DESTINATIONS = new String[]{"requestClose", "replyClose"};
    private static final Category log = Category.getInstance((Class)ListenerTest.class);

    public ListenerTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(ListenerTest.class);
    }

    public boolean share() {
        return false;
    }

    public boolean startConnection() {
        return false;
    }

    public String[] getDestinations() {
        return DESTINATIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectionStop() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        MessageReceiver receiver = this.createReceiver(REPLY);
        try {
            this.runTest(context, true, 10);
            Connection connection = context.getConnection();
            connection.start();
            this.receive(receiver, 10);
        }
        finally {
            receiver.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectionClose() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        TestContext context2 = TestContextHelper.createSendReceiveContext(context);
        MessageReceiver receiver = this.createReceiver(context2, REPLY);
        try {
            this.runTest(context, false, 10);
            context2.getConnection().start();
            this.receive(receiver, 10);
        }
        finally {
            receiver.remove();
            context2.getConnection().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(TestContext context, boolean stop, int count) throws Exception {
        int delayTime = 500;
        Connection connection = context.getConnection();
        Destination request = this.getDestination(REQUEST);
        MessageConsumer consumer = null;
        boolean durable = context.getMessagingBehaviour().getDurable();
        try {
            String name = durable ? SessionHelper.getSubscriberName() : null;
            consumer = SessionHelper.createConsumer(context, request, name);
            MessageSender sender = this.createSender(context, REPLY);
            EchoListener replier = new EchoListener(context.getSession(), sender, count, true);
            final WaitingListener listener = new WaitingListener(replier, 1);
            consumer.setMessageListener((MessageListener)listener);
            this.send(REQUEST, 1);
            connection.start();
            log.debug((Object)"waiting for listener");
            listener.waitForReceipt();
            log.debug((Object)"notifying listener");
            DelayedAction action = new DelayedAction(500L){

                public void runProtected() {
                    listener.notifyContinue();
                }
            };
            action.start();
            if (stop) {
                connection.stop();
            } else {
                connection.close();
            }
            listener.waitForCompletion();
        }
        catch (Throwable throwable) {
            try {
                consumer.close();
            }
            catch (Exception exception) {
                ListenerTest.fail((String)("Attempting to invoke close() for a consumer on a " + (stop ? "stopped" : "closed") + " connection threw " + "exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
            }
            throw throwable;
        }
        try {
            consumer.close();
        }
        catch (Exception exception) {
            ListenerTest.fail((String)("Attempting to invoke close() for a consumer on a " + (stop ? "stopped" : "closed") + " connection threw " + "exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
    }
}

