/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.clear;

import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageNotReadableException;
import javax.jms.StreamMessage;
import junit.framework.Assert;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.MessageVerifier;
import org.exolab.jmscts.test.message.util.EmptyMessageVerifier;
import org.exolab.jmscts.test.message.util.EmptyPropertyVerifier;

class ClearHelper
extends Assert {
    private static final Category log = Category.getInstance((Class)ClearHelper.class);

    ClearHelper() {
    }

    public static void checkClearProperties(Message message, MessageVerifier verifier, boolean provider) throws Exception {
        String msg;
        try {
            message.clearProperties();
        }
        catch (Exception exception) {
            msg = "Message.clearProperties() failed";
            log.debug((Object)msg, (Throwable)exception);
            ClearHelper.fail((String)(msg + ": " + exception));
        }
        try {
            EmptyPropertyVerifier empty = new EmptyPropertyVerifier(provider);
            empty.verify(message);
        }
        catch (Exception exception) {
            msg = "Expected clearProperties() to clear all properties";
            log.debug((Object)msg, (Throwable)exception);
            ClearHelper.fail((String)msg);
        }
        if (message instanceof BytesMessage) {
            ((BytesMessage)message).reset();
        } else if (message instanceof StreamMessage) {
            ((StreamMessage)message).reset();
        }
        try {
            verifier.verify(message);
        }
        catch (Exception exception) {
            msg = "Message body should not have changed after invoking Message.clearProperties() : " + exception;
            log.debug((Object)msg, (Throwable)exception);
            ClearHelper.fail((String)msg);
        }
    }

    public static void checkClearBody(Message message, MessageVerifier verifier) throws Exception {
        String msg;
        try {
            message.clearBody();
        }
        catch (Exception exception) {
            msg = "Message.clearBody() failed";
            log.debug((Object)msg, (Throwable)exception);
            ClearHelper.fail((String)(msg + ": " + exception));
        }
        try {
            verifier.verify(message);
        }
        catch (Exception exception) {
            msg = "Message properties should not have changed after invoking Message.clearBody()";
            log.debug((Object)msg, (Throwable)exception);
            ClearHelper.fail((String)(msg + ": " + exception));
        }
        EmptyMessageVerifier empty = null;
        if (message instanceof BytesMessage || message instanceof StreamMessage) {
            empty = new EmptyMessageVerifier(MessageNotReadableException.class);
            empty.verify(message);
            if (message instanceof BytesMessage) {
                ((BytesMessage)message).reset();
            } else if (message instanceof StreamMessage) {
                ((StreamMessage)message).reset();
            }
        }
        empty = ClearHelper.createEmptyVerifier(message);
        try {
            empty.verify(message);
        }
        catch (Exception exception) {
            String msg2 = "Message body should not have any content after invoking clearBody()";
            log.debug((Object)msg2, (Throwable)exception);
            ClearHelper.fail((String)(msg2 + ": " + exception));
        }
    }

    public static EmptyMessageVerifier createEmptyVerifier(Message message) {
        EmptyMessageVerifier result = null;
        result = message instanceof BytesMessage || message instanceof StreamMessage ? new EmptyMessageVerifier(MessageEOFException.class) : new EmptyMessageVerifier();
        return result;
    }
}

