/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.clear;

import javax.jms.Message;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractMessageTestCase;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.clear.ClearHelper;
import org.exolab.jmscts.test.message.util.EmptyMessageVerifier;
import org.exolab.jmscts.test.message.util.EmptyPropertyVerifier;
import org.exolab.jmscts.test.message.util.MessagePopulatorVerifier;
import org.exolab.jmscts.test.message.util.MessagePropertyVerifier;
import org.exolab.jmscts.test.message.util.PopulatorVerifierFactory;

public class ClearTest
extends AbstractMessageTestCase {
    public ClearTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createMessageTest(ClearTest.class);
    }

    public MessagePopulator getMessagePopulator() {
        return null;
    }

    public void testClearPropertiesOnCreation() throws Exception {
        TestContext context = this.getContext();
        Message message = context.getMessage();
        EmptyMessageVerifier empty = ClearHelper.createEmptyVerifier(message);
        ClearHelper.checkClearProperties(message, empty, false);
    }

    public void testClearBodyOnCreation() throws Exception {
        this.checkClearBodyOnCreation();
    }

    public void testBytesClearBodyOnCreation() throws Exception {
        this.checkClearBodyOnCreation();
    }

    public void testStreamClearBodyOnCreation() throws Exception {
        this.checkClearBodyOnCreation();
    }

    public void testClearProperties() throws Exception {
        TestContext context = this.getContext();
        Message message = context.getMessage();
        MessagePropertyVerifier properties = new MessagePropertyVerifier();
        ((MessagePopulatorVerifier)properties).populate(message);
        MessagePopulatorVerifier body = PopulatorVerifierFactory.create(message);
        body.populate(message);
        ClearHelper.checkClearProperties(message, body, false);
    }

    public void testClearBody() throws Exception {
        this.checkClearBody();
    }

    public void testBytesClearBody() throws Exception {
        this.checkClearBody();
    }

    public void testStreamClearBody() throws Exception {
        this.checkClearBody();
    }

    private void checkClearBodyOnCreation() throws Exception {
        TestContext context = this.getContext();
        Message message = context.getMessage();
        ClearHelper.checkClearBody(message, new EmptyPropertyVerifier());
    }

    private void checkClearBody() throws Exception {
        TestContext context = this.getContext();
        Message message = context.getMessage();
        MessagePropertyVerifier properties = new MessagePropertyVerifier();
        ((MessagePopulatorVerifier)properties).populate(message);
        MessagePopulatorVerifier body = PopulatorVerifierFactory.create(message);
        body.populate(message);
        ClearHelper.checkClearBody(message, properties);
    }
}

