/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.copy;

import java.util.Arrays;
import javax.jms.MapMessage;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractMessageTestCase;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.util.MessageValues;

public class MapMessageTest
extends AbstractMessageTestCase
implements MessageValues {
    public MapMessageTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createMessageTest(MapMessageTest.class);
    }

    public MessagePopulator getMessagePopulator() {
        return null;
    }

    public void testSetBytesCopy() throws Exception {
        int size = 10;
        String name = "test";
        TestContext context = this.getContext();
        MapMessage message = (MapMessage)context.getMessage();
        byte[] bytes = new byte[10];
        Arrays.fill(bytes, (byte)0);
        message.setBytes("test", bytes);
        Arrays.fill(bytes, (byte)1);
        MapMessageTest.assertTrue((String)"MapMessage.setBytes(byte[]) did not copy the array", (!Arrays.equals(message.getBytes("test"), bytes) ? 1 : 0) != 0);
        byte[] value1 = message.getBytes("test");
        byte[] value2 = message.getBytes("test");
        MapMessageTest.assertTrue((String)"MapMessage.getBytes() did not copy the array", (value1 != value2 ? 1 : 0) != 0);
    }

    public void testPartialSetBytesCopy() throws Exception {
        int size = 10;
        String name = "test";
        TestContext context = this.getContext();
        MapMessage message = (MapMessage)context.getMessage();
        byte[] bytes = new byte[10];
        Arrays.fill(bytes, (byte)0);
        message.setBytes("test", bytes, 1, 9);
        Arrays.fill(bytes, (byte)1);
        MapMessageTest.assertTrue((String)"MapMessage.setBytes(byte[], int, int) did not copy the array", (!Arrays.equals(message.getBytes("test"), bytes) ? 1 : 0) != 0);
        byte[] value1 = message.getBytes("test");
        byte[] value2 = message.getBytes("test");
        MapMessageTest.assertTrue((String)"MapMessage.getBytes() did not copy the array", (value1 != value2 ? 1 : 0) != 0);
    }

    public void testByteArrayCopy() throws Exception {
        int size = 10;
        String name = "test";
        TestContext context = this.getContext();
        MapMessage message = (MapMessage)context.getMessage();
        byte[] bytes = new byte[10];
        Arrays.fill(bytes, (byte)0);
        message.setObject("test", (Object)bytes);
        Arrays.fill(bytes, (byte)1);
        byte[] value = (byte[])message.getObject("test");
        MapMessageTest.assertTrue((String)"MapMessage.setObject() did not copy the byte array", (!Arrays.equals(value, bytes) ? 1 : 0) != 0);
        byte[] value1 = (byte[])message.getObject("test");
        byte[] value2 = (byte[])message.getObject("test");
        MapMessageTest.assertTrue((String)"MapMessage.getObject() did not copy the byte array", (value1 != value2 ? 1 : 0) != 0);
    }
}

