/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.copy;

import java.util.LinkedList;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.StreamMessage;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.ChainedMessagePopulator;
import org.exolab.jmscts.core.MessageBodyComparer;
import org.exolab.jmscts.core.MessageCreator;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.MessagePropertyComparer;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.MessageTypes;
import org.exolab.jmscts.core.SequenceMessagePopulator;
import org.exolab.jmscts.core.SequencePropertyPopulator;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class MessageCopyTest
extends AbstractSendReceiveTestCase {
    private static final String DESTINATION = "MessageCopyTest";

    public MessageCopyTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(MessageCopyTest.class);
    }

    public MessagePopulator getMessagePopulator() {
        return null;
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyOnSend() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        Session session = context.getSession();
        Message message = context.getMessage();
        LinkedList<Message> expected = new LinkedList<Message>();
        MessageReceiver receiver = this.createReceiver(DESTINATION);
        MessageSender sender = this.createSender(DESTINATION);
        SequencePropertyPopulator property = new SequencePropertyPopulator();
        SequenceMessagePopulator body = new SequenceMessagePopulator();
        SequencePropertyPopulator propertyDuplicator = new SequencePropertyPopulator();
        SequenceMessagePopulator bodyDuplicator = new SequenceMessagePopulator();
        ChainedMessagePopulator populator = new ChainedMessagePopulator(new MessagePopulator[]{property, body});
        ChainedMessagePopulator duplicator = new ChainedMessagePopulator(new MessagePopulator[]{propertyDuplicator, bodyDuplicator});
        List messages = null;
        boolean appender = message instanceof BytesMessage || message instanceof StreamMessage;
        Class type = MessageTypes.getType(message);
        try {
            for (int i = 0; i < 10; ++i) {
                Message copy;
                MessageCreator creator;
                sender.send(message, 1, populator);
                if (appender) {
                    creator = new MessageCreator(session, propertyDuplicator);
                    copy = creator.create(type);
                    bodyDuplicator = new SequenceMessagePopulator();
                    for (int j = 0; j <= i; ++j) {
                        bodyDuplicator.populate(copy);
                    }
                } else {
                    creator = new MessageCreator(session, duplicator);
                    copy = creator.create(type);
                }
                expected.add(copy);
            }
            if (session.getTransacted()) {
                session.commit();
            }
            messages = this.receive(receiver, 10);
            MessagePropertyComparer propertyComparer = new MessagePropertyComparer(true);
            MessageBodyComparer bodyComparer = new MessageBodyComparer();
            for (int i = 0; i < 10; ++i) {
                String msg;
                Message sent = (Message)expected.get(i);
                Message received = (Message)messages.get(i);
                if (sent instanceof BytesMessage) {
                    ((BytesMessage)sent).reset();
                    ((BytesMessage)received).reset();
                } else if (sent instanceof StreamMessage) {
                    ((StreamMessage)sent).reset();
                    ((StreamMessage)received).reset();
                }
                if (!propertyComparer.compare(sent, received)) {
                    msg = "Received message has different properties to that sent";
                    MessageCopyTest.fail((String)msg);
                }
                if (bodyComparer.compare(sent, received)) continue;
                msg = "Received message has different data to that sent";
                MessageCopyTest.fail((String)msg);
            }
        }
        finally {
            receiver.remove();
            sender.close();
        }
    }
}

