/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.header;

import java.util.Arrays;
import javax.jms.JMSException;
import javax.jms.Message;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class JMSCorrelationIDTest
extends AbstractSendReceiveTestCase {
    private static final String DESTINATION = "JMSCorrelationIDTest";

    public JMSCorrelationIDTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(JMSCorrelationIDTest.class);
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    public void testCorrelationID() throws Exception {
        TestContext context = this.getContext();
        Message message = context.getMessage();
        JMSCorrelationIDTest.assertNull((String)"getJMSCorrelationID() should return null, as no value is set", (Object)message.getJMSCorrelationID());
        String correlationID = "my correlation Id";
        try {
            message.setJMSCorrelationID(correlationID);
        }
        catch (JMSException exception) {
            JMSCorrelationIDTest.fail((String)"Failed to set a valid application specific correlation ID");
        }
        Message received = this.sendReceive(message, DESTINATION);
        JMSCorrelationIDTest.assertEquals((String)"JMSCorrelationID on received message doesn't match that sent", (String)correlationID, (String)received.getJMSCorrelationID());
    }

    public void testNullCorrelationID() throws Exception {
        TestContext context = this.getContext();
        Message message = context.getMessage();
        try {
            message.setJMSCorrelationID(null);
        }
        catch (JMSException exception) {
            JMSCorrelationIDTest.fail((String)"Failed to set JMSCorrelationID to null");
        }
        String correlationID = "a correlation Id";
        message.setJMSCorrelationID(correlationID);
        Message received1 = this.sendReceive(message, DESTINATION);
        JMSCorrelationIDTest.assertEquals((String)"JMSCorrelationID on received message doesn't match that sent", (String)correlationID, (String)received1.getJMSCorrelationID());
        try {
            received1.setJMSCorrelationID(null);
        }
        catch (JMSException exception) {
            JMSCorrelationIDTest.fail((String)"Failed to set JMSCorrelationID on received message to null");
        }
        Message received2 = this.sendReceive(received1, DESTINATION);
        JMSCorrelationIDTest.assertNull((String)"JMSCorrelationID on received message should be null", (Object)received2.getJMSCorrelationID());
    }

    public void testCorrelationIDAsBytes() throws Exception {
        int size = 10;
        TestContext context = this.getContext();
        Message message = context.getMessage();
        byte[] masterId = new byte[10];
        byte[] id = new byte[10];
        for (int i = 0; i < 10; ++i) {
            masterId[i] = (byte)i;
            id[i] = masterId[i];
        }
        try {
            if (message.getJMSCorrelationIDAsBytes() != null) {
                JMSCorrelationIDTest.fail((String)"getJMSCorrelationIDAsBytes() should return null, as no value is set");
            }
            message.setJMSCorrelationIDAsBytes(id);
            Arrays.fill(id, (byte)0);
            JMSCorrelationIDTest.assertTrue((message.getJMSCorrelationIDAsBytes() != id ? 1 : 0) != 0);
            JMSCorrelationIDTest.assertTrue((!Arrays.equals(id, message.getJMSCorrelationIDAsBytes()) ? 1 : 0) != 0);
            Message received = this.sendReceive(message, DESTINATION);
            JMSCorrelationIDTest.assertTrue((boolean)Arrays.equals(masterId, received.getJMSCorrelationIDAsBytes()));
        }
        catch (UnsupportedOperationException ignore) {
            context.getCoverage().setUnsupported("message.correlation.bytes");
        }
    }
}

