/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.properties;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractMessageTestCase;
import org.exolab.jmscts.core.ClassHelper;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.properties.PropertyHelper;

public class JMSXGroupTest
extends AbstractMessageTestCase {
    private static final String GROUP_ID = "JMSXGroupID";
    private static final String GROUP_SEQ = "JMSXGroupSeq";
    private static final Object[] INVALID_GROUP_ID_VALUES = new Object[]{Boolean.TRUE, new Byte(-128), new Short(Short.MIN_VALUE), new Character('\u0000'), new Integer(Integer.MIN_VALUE), new Float(Float.MIN_VALUE), new Double(Double.MIN_VALUE)};
    private static final Object[] INVALID_GROUP_SEQ_VALUES = new Object[]{Boolean.TRUE, new Byte(-128), new Short(Short.MIN_VALUE), new Character('\u0000'), new Float(Float.MIN_VALUE), new Double(Double.MIN_VALUE), "abc"};

    public JMSXGroupTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createMessageTest(JMSXGroupTest.class);
    }

    public void testJMSXGroupID() throws Exception {
        Message message = this.getContext().getMessage();
        for (int i = 0; i < INVALID_GROUP_ID_VALUES.length; ++i) {
            Object value = INVALID_GROUP_ID_VALUES[i];
            this.checkProperty(message, GROUP_ID, value);
        }
    }

    public void testJMSGroupSeq() throws Exception {
        Message message = this.getContext().getMessage();
        for (int i = 0; i < INVALID_GROUP_SEQ_VALUES.length; ++i) {
            Object value = INVALID_GROUP_SEQ_VALUES[i];
            this.checkProperty(message, GROUP_SEQ, value);
        }
    }

    public void testJMSGroupSeqRange() throws Exception {
        Message message = this.getContext().getMessage();
        this.checkSequenceValue(message, -1, false);
        this.checkSequenceValue(message, 0, false);
        this.checkSequenceValue(message, 1, true);
        this.checkSequenceValue(message, Integer.MAX_VALUE, true);
    }

    private void checkProperty(Message message, String name, Object value) throws Exception {
        if (!(value instanceof Character)) {
            try {
                PropertyHelper.setPrimitiveProperty(message, name, value);
                JMSXGroupTest.fail((String)("Managed to use invalid type=" + ClassHelper.getPrimitiveName(value.getClass()) + " for property=" + name));
            }
            catch (MessageFormatException expected) {
            }
            catch (Exception exception) {
                JMSXGroupTest.fail((String)("Expected MessageFormatException to be thrown when setting property=" + name + " with type=" + ClassHelper.getPrimitiveName(value.getClass()) + " but got exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
            }
        }
        try {
            message.setObjectProperty(name, value);
            JMSXGroupTest.fail((String)("Managed to use invalid type=" + ClassHelper.getPrimitiveName(value.getClass()) + " for property=" + name));
        }
        catch (MessageFormatException expected) {
        }
        catch (Exception exception) {
            JMSXGroupTest.fail((String)("Expected MessageFormatException to be thrown when setting property=" + name + " with type=" + ClassHelper.getPrimitiveName(value.getClass()) + " but got exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
    }

    private void checkSequenceValue(Message message, int value, boolean valid) throws Exception {
        this.checkSequenceValue(message, value, valid, true);
        this.checkSequenceValue(message, value, valid, false);
    }

    private void checkSequenceValue(Message message, int value, boolean valid, boolean primitive) throws Exception {
        try {
            if (primitive) {
                message.setIntProperty(GROUP_SEQ, value);
            } else {
                message.setObjectProperty(GROUP_SEQ, (Object)new Integer(value));
            }
            if (!valid) {
                JMSXGroupTest.fail((String)("Managed to use invalid int=" + value + " for property=" + GROUP_SEQ));
            }
        }
        catch (JMSException exception) {
            if (valid) {
                JMSXGroupTest.fail((String)("Valid int value=" + value + " for property=" + GROUP_SEQ + " threw exception=" + ((Object)((Object)exception)).getClass() + ", message=" + exception.getMessage()));
            }
        }
        catch (Exception exception) {
            if (valid) {
                JMSXGroupTest.fail((String)("Valid int value=" + value + " for property=" + GROUP_SEQ + " threw exception=" + exception.getClass() + ", message=" + exception.getMessage()));
            }
            JMSXGroupTest.fail((String)("Expected JMSException to be thrown when setting property=JMSXGroupSeq with value=" + value + " but got exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
    }
}

