/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.properties;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import org.exolab.jmscts.core.ClassHelper;
import org.exolab.jmscts.test.message.util.PropertyValues;

final class PropertyHelper
implements PropertyValues {
    private PropertyHelper() {
    }

    public static Set setProperties(Message message) throws Exception {
        HashSet set = new HashSet();
        int count = 0;
        for (int i = 0; i < ALL_VALUES.length; ++i) {
            PropertyHelper.setPrimitiveProperties(message, ALL_VALUES[i], set);
            PropertyHelper.setObjectProperties(message, ALL_VALUES[i], set);
            count += ALL_VALUES[i].length * 2;
        }
        if (set.size() != count) {
            throw new Exception("Expected " + count + " properties to be " + "set, but got " + set.size());
        }
        return set;
    }

    public static void setPrimitiveProperties(Message message, Object[] values, Set set) throws JMSException {
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            String name = PropertyHelper.getName(ClassHelper.getPrimitiveType(value.getClass()), i);
            PropertyHelper.setPrimitiveProperty(message, name, value);
            set.add(name);
        }
    }

    public static void setObjectProperties(Message message, Object[] values, Set set) throws JMSException {
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            String name = null;
            name = value instanceof String ? "java_lang_String" + i : PropertyHelper.getName(value.getClass(), i);
            message.setObjectProperty(name, value);
            set.add(name);
        }
    }

    public static void setPrimitiveProperty(Message message, String name, Object value) throws JMSException {
        if (value instanceof Boolean) {
            message.setBooleanProperty(name, ((Boolean)value).booleanValue());
        } else if (value instanceof Byte) {
            message.setByteProperty(name, ((Byte)value).byteValue());
        } else if (value instanceof Short) {
            message.setShortProperty(name, ((Short)value).shortValue());
        } else if (value instanceof Integer) {
            message.setIntProperty(name, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            message.setLongProperty(name, ((Long)value).longValue());
        } else if (value instanceof Float) {
            message.setFloatProperty(name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            message.setDoubleProperty(name, ((Double)value).doubleValue());
        } else {
            message.setStringProperty(name, (String)value);
        }
    }

    public static Map getProperties(Message message) throws JMSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Enumeration iter = message.getPropertyNames();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            Object value = message.getObjectProperty(name);
            result.put(name, value);
        }
        return result;
    }

    private static String getName(Class type, int id) {
        String name = null;
        name = type.equals(String.class) ? "String" : (type.isPrimitive() ? type.getName() : type.getName().replace('.', '_'));
        return name + id;
    }
}

