/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.properties;

import java.util.Map;
import java.util.Set;
import javax.jms.Message;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.properties.PropertyHelper;

public class PropertyTest
extends AbstractSendReceiveTestCase {
    private static final String DESTINATION = "PropertyTest";

    public PropertyTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(PropertyTest.class);
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    public void testPropertyIntegrity() throws Exception {
        Message message = this.getContext().getMessage();
        Map beforeProperties = null;
        Map afterProperties = null;
        Map receivedProperties = null;
        Set names = PropertyHelper.setProperties(message);
        if (!((Object)names).equals((beforeProperties = PropertyHelper.getProperties(message)).keySet())) {
            PropertyTest.fail((String)"The list of property names returned by getPropertyNames() is different to that set");
        }
        Message received = this.sendReceive(message, DESTINATION);
        afterProperties = PropertyHelper.getProperties(message);
        if (!((Object)beforeProperties).equals(afterProperties)) {
            PropertyTest.fail((String)"The list of property names returned by getPropertyNames() on the received message is different to that set");
        }
        receivedProperties = PropertyHelper.getProperties(received);
        Object[] keys = receivedProperties.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String name = (String)keys[i];
            if (!name.startsWith("JMSX") && !name.startsWith("JMS_")) continue;
            receivedProperties.remove(name);
        }
        if (!((Object)beforeProperties).equals(receivedProperties)) {
            String msg = "Properties sent don't match those received";
            PropertyTest.fail((String)msg);
        }
        received.clearProperties();
        PropertyHelper.setProperties(received);
    }

    public void testPropertyNames() throws Exception {
        String[] headerNames = new String[]{"JMSDestination", "JMSDeliveryMode", "JMSExpiration", "JMSPriority", "JMSMessageID", "JMSTimestamp", "JMSCorrelationID", "JMSReplyTo", "JMSType", "JMSRedelivered"};
        Message message = this.getContext().getMessage();
        for (int i = 0; i < headerNames.length; ++i) {
            if (!message.propertyExists(headerNames[i])) continue;
            PropertyTest.fail((String)("Message.propertyExists() returned true for JMS header field=" + headerNames[i]));
        }
        Message received = this.sendReceive(message, DESTINATION);
        for (int i = 0; i < headerNames.length; ++i) {
            if (message.propertyExists(headerNames[i])) {
                PropertyTest.fail((String)("Message.propertyExists() returned true for JMS header field=" + headerNames[i] + " after the message " + "was sent"));
            }
            if (!received.propertyExists(headerNames[i])) continue;
            PropertyTest.fail((String)("Message.propertyExists() returned true for JMS header field=" + headerNames[i] + " for a received message"));
        }
    }
}

