/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.readwrite;

import javax.jms.Message;
import javax.jms.MessageNotWriteableException;
import javax.jms.Session;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.SequenceMessagePopulator;
import org.exolab.jmscts.core.SequencePropertyPopulator;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.message.util.MessagePopulatorVerifier;
import org.exolab.jmscts.test.message.util.MessagePropertyVerifier;
import org.exolab.jmscts.test.message.util.PopulatorVerifierFactory;
import org.exolab.jmscts.test.message.util.PropertyValues;

public class SendReceiveReadWriteTest
extends AbstractSendReceiveTestCase
implements PropertyValues {
    private static final String DESTINATION = "SendReceiveReadWriteTest";
    private static final Category log = Category.getInstance((Class)SendReceiveReadWriteTest.class);

    public SendReceiveReadWriteTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(SendReceiveReadWriteTest.class);
    }

    public MessagePopulator getMessagePopulator() {
        return null;
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteableOnSend() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        Session session = context.getSession();
        Message message = context.getMessage();
        MessageSender sender = this.createSender(DESTINATION);
        SequencePropertyPopulator property = new SequencePropertyPopulator();
        SequenceMessagePopulator body = new SequenceMessagePopulator();
        try {
            for (int i = 0; i < 10; ++i) {
                String msg;
                try {
                    property.populate(message);
                }
                catch (Exception exception) {
                    msg = "Failed to populate message properties on " + i + " iteration prior to send";
                    log.error((Object)msg, (Throwable)exception);
                    SendReceiveReadWriteTest.fail((String)(msg + ": " + exception));
                }
                try {
                    body.populate(message);
                }
                catch (Exception exception) {
                    msg = "Failed to populate message body on " + i + " iteration prior to send";
                    log.error((Object)msg, (Throwable)exception);
                    SendReceiveReadWriteTest.fail((String)(msg + ": " + exception));
                }
                sender.send(message, 1);
            }
        }
        finally {
            sender.close();
        }
    }

    public void testReadOnlyOnReceipt() throws Exception {
        TestContext context = this.getContext();
        Session session = context.getSession();
        Message message = context.getMessage();
        Class exceptionType = MessageNotWriteableException.class;
        MessagePropertyVerifier properties = new MessagePropertyVerifier(exceptionType);
        MessagePopulatorVerifier body = PopulatorVerifierFactory.create(message, exceptionType);
        Message received = this.sendReceive(message, DESTINATION);
        try {
            ((MessagePopulatorVerifier)properties).populate(received);
        }
        catch (Exception exception) {
            SendReceiveReadWriteTest.fail((String)("Expected MessageNotWriteableException to be thrown when populating the properties of a received message, but  got exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
        try {
            body.populate(received);
        }
        catch (Exception exception) {
            SendReceiveReadWriteTest.fail((String)("Expected MessageNotWriteableException to be thrown when populating the body of a received message, but  got exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
        try {
            received.clearProperties();
        }
        catch (Exception exception) {
            SendReceiveReadWriteTest.fail((String)("Attempt to clear the properties of a received message threw exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
        try {
            received.clearBody();
        }
        catch (Exception exception) {
            SendReceiveReadWriteTest.fail((String)("Attempt to clear the body of a received message threw exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
        }
    }
}

