/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.util;

import java.util.HashMap;

public final class Conversions {
    public static final Class[] TYPES = new Class[]{Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, String.class, [B.class};
    private static final Class[] BOOLEAN = new Class[]{Boolean.class, String.class};
    private static final Class[] BYTE = new Class[]{Byte.class, Short.class, Integer.class, Long.class, String.class};
    private static final Class[] SHORT = new Class[]{Short.class, Integer.class, Long.class, String.class};
    private static final Class[] CHAR = new Class[]{Character.class, String.class};
    private static final Class[] INT = new Class[]{Integer.class, Long.class, String.class};
    private static final Class[] LONG = new Class[]{Long.class, String.class};
    private static final Class[] FLOAT = new Class[]{Float.class, Double.class, String.class};
    private static final Class[] DOUBLE = new Class[]{Double.class, String.class};
    private static final Class[] STRING = new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class};
    private static final Class[] BYTES = new Class[]{[B.class};
    private static final HashMap VALID = new HashMap();
    private static final HashMap INVALID;

    private Conversions() {
    }

    public static Class[] getValidConversions(Class type) {
        Class[] result = (Class[])VALID.get(type);
        if (result == null) {
            throw new IllegalArgumentException("Class=" + type.getName() + " is not a type supported by " + "MapMessage or StreamMessage");
        }
        return result;
    }

    public static Class[] getInvalidConversions(Class type) {
        Class[] result = (Class[])INVALID.get(type);
        if (result == null) {
            throw new IllegalArgumentException("Class=" + type.getName() + " is not a type supported by " + "MapMessage or StreamMessage");
        }
        return result;
    }

    public static boolean isValidConversion(Object value, Class type) {
        boolean result = false;
        Class[] valid = Conversions.getValidConversions(value.getClass());
        for (int i = 0; i < valid.length; ++i) {
            if (!valid[i].equals(type)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static Object convert(Object value, Class type) {
        Object result = null;
        if (value instanceof Boolean) {
            result = Conversions.convertBoolean((Boolean)value, type);
        } else if (value instanceof Byte) {
            result = Conversions.convertByte((Byte)value, type);
        } else if (value instanceof Short) {
            result = Conversions.convertShort((Short)value, type);
        } else if (value instanceof Character) {
            result = Conversions.convertChar((Character)value, type);
        } else if (value instanceof Integer) {
            result = Conversions.convertInt((Integer)value, type);
        } else if (value instanceof Long) {
            result = Conversions.convertLong((Long)value, type);
        } else if (value instanceof Float) {
            result = Conversions.convertFloat((Float)value, type);
        } else if (value instanceof Double) {
            result = Conversions.convertDouble((Double)value, type);
        } else if (value instanceof String) {
            result = Conversions.convertString((String)value, type);
        } else if (value instanceof byte[]) {
            if (type.equals([B.class)) {
                result = value;
            } else {
                Conversions.illegalConversion(value, type);
            }
        }
        return result;
    }

    public static Object convertBoolean(Boolean value, Class type) {
        Object result = null;
        if (type.equals(Boolean.class)) {
            result = value;
        } else if (type.equals(String.class)) {
            result = value.toString();
        } else {
            Conversions.illegalConversion(value, type);
        }
        return result;
    }

    public static Object convertByte(Byte value, Class type) {
        return Conversions.convertNumber(value, type);
    }

    public static Object convertShort(Short value, Class type) {
        return Conversions.convertNumber(value, type);
    }

    public static Object convertChar(Character value, Class type) {
        Object result = null;
        if (type.equals(Character.class)) {
            result = value;
        } else if (type.equals(String.class)) {
            result = value.toString();
        } else {
            Conversions.illegalConversion(value, type);
        }
        return result;
    }

    public static Object convertInt(Integer value, Class type) {
        return Conversions.convertNumber(value, type);
    }

    public static Object convertLong(Long value, Class type) {
        return Conversions.convertNumber(value, type);
    }

    public static Object convertFloat(Float value, Class type) {
        return Conversions.convertNumber(value, type);
    }

    public static Object convertDouble(Double value, Class type) {
        return Conversions.convertNumber(value, type);
    }

    public static Object convertString(String value, Class type) {
        Object result = null;
        if (type.equals(Boolean.class)) {
            result = Boolean.valueOf(value);
        } else if (type.equals(Byte.class)) {
            result = Byte.valueOf(value);
        } else if (type.equals(Short.class)) {
            result = Short.valueOf(value);
        } else if (type.equals(Integer.class)) {
            result = Integer.valueOf(value);
        } else if (type.equals(Float.class)) {
            result = Float.valueOf(value);
        } else if (type.equals(Double.class)) {
            result = Double.valueOf(value);
        } else if (type.equals(String.class)) {
            result = value;
        } else {
            Conversions.illegalConversion(value, type);
        }
        return result;
    }

    private static Object convertNumber(Number value, Class type) {
        Object result = null;
        if (!Conversions.isValidConversion(value, type)) {
            Conversions.illegalConversion(value, type);
        }
        if (type.equals(Byte.class)) {
            result = new Byte(value.byteValue());
        } else if (type.equals(Short.class)) {
            result = new Short(value.shortValue());
        } else if (type.equals(Integer.class)) {
            result = new Integer(value.intValue());
        } else if (type.equals(Long.class)) {
            result = new Long(value.longValue());
        } else if (type.equals(Float.class)) {
            result = new Float(value.floatValue());
        } else if (type.equals(Double.class)) {
            result = new Double(value.doubleValue());
        } else if (type.equals(String.class)) {
            result = value.toString();
        }
        return result;
    }

    private static void illegalConversion(Object value, Class type) {
        throw new IllegalArgumentException("Type=" + type.getName() + " is not a valid conversion for " + value.getClass().getName());
    }

    private static Class[] getInvalid(Class type) {
        Class[] valid = Conversions.getValidConversions(type);
        Class[] invalid = new Class[TYPES.length - valid.length];
        int index = 0;
        for (int i = 0; i < TYPES.length; ++i) {
            boolean found = false;
            for (int j = 0; j < valid.length; ++j) {
                if (!TYPES[i].equals(valid[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            invalid[index++] = TYPES[i];
        }
        return invalid;
    }

    static {
        VALID.put(Boolean.class, BOOLEAN);
        VALID.put(Byte.class, BYTE);
        VALID.put(Short.class, SHORT);
        VALID.put(Character.class, CHAR);
        VALID.put(Integer.class, INT);
        VALID.put(Long.class, LONG);
        VALID.put(Float.class, FLOAT);
        VALID.put(Double.class, DOUBLE);
        VALID.put(String.class, STRING);
        VALID.put([B.class, BYTES);
        INVALID = new HashMap();
        INVALID.put(Boolean.class, Conversions.getInvalid(Boolean.class));
        INVALID.put(Byte.class, Conversions.getInvalid(Byte.class));
        INVALID.put(Short.class, Conversions.getInvalid(Short.class));
        INVALID.put(Character.class, Conversions.getInvalid(Character.class));
        INVALID.put(Integer.class, Conversions.getInvalid(Integer.class));
        INVALID.put(Long.class, Conversions.getInvalid(Long.class));
        INVALID.put(Float.class, Conversions.getInvalid(Float.class));
        INVALID.put(Double.class, Conversions.getInvalid(Double.class));
        INVALID.put(String.class, Conversions.getInvalid(String.class));
        INVALID.put([B.class, Conversions.getInvalid([B.class));
    }
}

