/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.util;

import javax.jms.MapMessage;
import javax.jms.Message;
import org.exolab.jmscts.core.MethodCache;
import org.exolab.jmscts.test.message.util.MessagePopulatorVerifier;

class MapMessageVerifier
extends MessagePopulatorVerifier {
    private static MethodCache _methods = null;
    private int _seed = 0;
    private static final int BYTE_ARRAY_SIZE = 10;

    public MapMessageVerifier() {
    }

    public MapMessageVerifier(Class exception) {
        super(exception);
    }

    public void populateMapMessage(MapMessage message) throws Exception {
        byte[] bytes = new byte[10];
        this._seed = 0;
        this.set((Message)message, "setBoolean", Boolean.TRUE);
        this.set((Message)message, "setByte", new Byte(-128));
        this.set((Message)message, "setBytes", (Object)bytes);
        Object[] args = new Object[]{bytes, new Integer(1), new Integer(bytes.length - 2)};
        this.set((Message)message, "setBytes", args);
        this.set((Message)message, "setChar", new Character('\u0000'));
        this.set((Message)message, "setDouble", new Double(Double.MIN_VALUE));
        this.set((Message)message, "setFloat", new Float(Float.MIN_VALUE));
        this.set((Message)message, "setInt", new Integer(Integer.MIN_VALUE));
        this.set((Message)message, "setLong", new Long(Long.MIN_VALUE));
        this.set((Message)message, "setShort", new Short(Short.MIN_VALUE));
        this.set((Message)message, "setString", "ABC");
        this.set((Message)message, "setObject", Boolean.TRUE);
        this.set((Message)message, "setObject", new Byte(127));
        this.set((Message)message, "setObject", (Object)bytes);
        this.set((Message)message, "setObject", new Character('\uffff'));
        this.set((Message)message, "setObject", new Double(Double.MAX_VALUE));
        this.set((Message)message, "setObject", new Float(Float.MAX_VALUE));
        this.set((Message)message, "setObject", new Integer(Integer.MAX_VALUE));
        this.set((Message)message, "setObject", new Long(Long.MAX_VALUE));
        this.set((Message)message, "setObject", new Short(Short.MAX_VALUE));
        this.set((Message)message, "setObject", "ABC");
    }

    public void verifyMapMessage(MapMessage message) throws Exception {
        this._seed = 0;
        this.get((Message)message, "getBoolean", Boolean.TRUE);
        this.get((Message)message, "getByte", new Byte(-128));
        this.get((Message)message, "getBytes", new byte[10]);
        this.get((Message)message, "getBytes", new byte[8]);
        this.get((Message)message, "getChar", new Character('\u0000'));
        this.get((Message)message, "getDouble", new Double(Double.MIN_VALUE));
        this.get((Message)message, "getFloat", new Float(Float.MIN_VALUE));
        this.get((Message)message, "getInt", new Integer(Integer.MIN_VALUE));
        this.get((Message)message, "getLong", new Long(Long.MIN_VALUE));
        this.get((Message)message, "getShort", new Short(Short.MIN_VALUE));
        this.get((Message)message, "getString", "ABC");
        this.get((Message)message, "getObject", Boolean.TRUE);
        this.get((Message)message, "getObject", new Byte(127));
        this.get((Message)message, "getObject", new byte[10]);
        this.get((Message)message, "getObject", new Character('\uffff'));
        this.get((Message)message, "getObject", new Double(Double.MAX_VALUE));
        this.get((Message)message, "getObject", new Float(Float.MAX_VALUE));
        this.get((Message)message, "getObject", new Integer(Integer.MAX_VALUE));
        this.get((Message)message, "getObject", new Long(Long.MAX_VALUE));
        this.get((Message)message, "getObject", new Short(Short.MAX_VALUE));
        this.get((Message)message, "getObject", "ABC");
    }

    protected void set(Message message, String method, Object value) throws Exception {
        Object[] args = new Object[]{"name" + ++this._seed, value};
        this.invoke(message, method, args);
    }

    protected void set(Message message, String method, Object[] values) throws Exception {
        Object[] args = new Object[values.length + 1];
        args[0] = "name" + ++this._seed;
        System.arraycopy(values, 0, args, 1, values.length);
        this.invoke(message, method, args);
    }

    protected void get(Message message, String method, Object expected) throws Exception {
        Object[] args = new Object[]{"name" + ++this._seed};
        this.expect(message, method, args, expected);
    }

    protected void get(Message message, String method, Object[] values, Object expected) throws Exception {
        Object[] args = new Object[values.length + 1];
        args[0] = "name" + ++this._seed;
        System.arraycopy(values, 0, args, 1, values.length);
        this.expect(message, method, args, expected);
    }

    protected synchronized MethodCache getMethods() {
        if (_methods == null) {
            _methods = new MethodCache(MapMessage.class);
        }
        return _methods;
    }
}

