/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.message.util;

import javax.jms.Message;
import javax.jms.StreamMessage;
import org.exolab.jmscts.core.MethodCache;
import org.exolab.jmscts.test.message.util.MessagePopulatorVerifier;

class StreamMessageVerifier
extends MessagePopulatorVerifier {
    private static MethodCache _methods = null;
    private static final int BYTE_ARRAY_SIZE = 10;

    public StreamMessageVerifier() {
    }

    public StreamMessageVerifier(Class exception) {
        super(exception);
    }

    public void populateStreamMessage(StreamMessage message) throws Exception {
        byte[] bytes = this.populateByteArray(10, 0);
        this.invoke((Message)message, "writeBoolean", Boolean.TRUE);
        this.invoke((Message)message, "writeByte", new Byte(-128));
        this.invoke((Message)message, "writeBytes", (Object)bytes);
        Object[] args = new Object[]{bytes, new Integer(1), new Integer(bytes.length - 2)};
        this.invoke((Message)message, "writeBytes", args);
        this.invoke((Message)message, "writeShort", new Short(Short.MIN_VALUE));
        this.invoke((Message)message, "writeChar", new Character('\u0000'));
        this.invoke((Message)message, "writeInt", new Integer(Integer.MIN_VALUE));
        this.invoke((Message)message, "writeLong", new Long(Long.MIN_VALUE));
        this.invoke((Message)message, "writeFloat", new Float(Float.MIN_VALUE));
        this.invoke((Message)message, "writeDouble", new Double(Double.MIN_VALUE));
        this.invoke((Message)message, "writeString", "ABC");
        this.invoke((Message)message, "writeObject", Boolean.TRUE);
        this.invoke((Message)message, "writeObject", new Byte(127));
        this.invoke((Message)message, "writeObject", (Object)bytes);
        this.invoke((Message)message, "writeObject", new Short(Short.MAX_VALUE));
        this.invoke((Message)message, "writeObject", new Character('\uffff'));
        this.invoke((Message)message, "writeObject", new Integer(Integer.MAX_VALUE));
        this.invoke((Message)message, "writeObject", new Long(Long.MAX_VALUE));
        this.invoke((Message)message, "writeObject", new Float(Float.MAX_VALUE));
        this.invoke((Message)message, "writeObject", new Double(Double.MAX_VALUE));
        this.invoke((Message)message, "writeObject", "ABC");
    }

    public void verifyStreamMessage(StreamMessage message) throws Exception {
        this.expect((Message)message, "readBoolean", Boolean.TRUE);
        this.expect((Message)message, "readByte", new Byte(-128));
        byte[] buffer1 = new byte[10];
        this.expect((Message)message, "readBytes", (Object)buffer1, (Object)new Integer(buffer1.length));
        this.equal(buffer1, this.populateByteArray(buffer1.length, 0));
        this.expect((Message)message, "readBytes", (Object)buffer1, (Object)new Integer(-1));
        byte[] buffer2 = new byte[8];
        this.expect((Message)message, "readBytes", (Object)buffer2, (Object)new Integer(buffer2.length));
        this.equal(buffer2, this.populateByteArray(buffer2.length, 1));
        this.expect((Message)message, "readBytes", (Object)buffer2, (Object)new Integer(-1));
        this.expect((Message)message, "readShort", new Short(Short.MIN_VALUE));
        this.expect((Message)message, "readChar", new Character('\u0000'));
        this.expect((Message)message, "readInt", new Integer(Integer.MIN_VALUE));
        this.expect((Message)message, "readLong", new Long(Long.MIN_VALUE));
        this.expect((Message)message, "readFloat", new Float(Float.MIN_VALUE));
        this.expect((Message)message, "readDouble", new Double(Double.MIN_VALUE));
        this.expect((Message)message, "readString", "ABC");
        this.expect((Message)message, "readObject", Boolean.TRUE);
        this.expect((Message)message, "readObject", new Byte(127));
        this.expect((Message)message, "readObject", this.populateByteArray(10, 0));
        this.expect((Message)message, "readObject", new Short(Short.MAX_VALUE));
        this.expect((Message)message, "readObject", new Character('\uffff'));
        this.expect((Message)message, "readObject", new Integer(Integer.MAX_VALUE));
        this.expect((Message)message, "readObject", new Long(Long.MAX_VALUE));
        this.expect((Message)message, "readObject", new Float(Float.MAX_VALUE));
        this.expect((Message)message, "readObject", new Double(Double.MAX_VALUE));
        this.expect((Message)message, "readObject", "ABC");
    }

    protected synchronized MethodCache getMethods() {
        if (_methods == null) {
            _methods = new MethodCache(StreamMessage.class);
        }
        return _methods;
    }
}

