/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.producer.ttl;

import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import junit.framework.Test;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.SessionHelper;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.producer.ttl.TimeToLiveTestCase;

public class QueueSenderTest
extends TimeToLiveTestCase {
    private static final String DESTINATION = "QueueSenderTest";
    private static final long TTL = 50000L;

    public QueueSenderTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(QueueSenderTest.class);
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    public void testDefaultTTL() throws Exception {
        long timeToLive = 0L;
        TestContext context = this.getContext();
        QueueSender sender = (QueueSender)SessionHelper.createProducer(context.getSession(), this.getDestination(DESTINATION));
        QueueSenderTest.assertEquals((String)"Default time-to-live incorrect for QueueSender", (long)0L, (long)sender.getTimeToLive());
        this.verifySend(sender, context.getMessage(), 0L);
        sender.close();
    }

    public void testDefaultTTLForAnonQueue() throws Exception {
        long timeToLive = 0L;
        TestContext context = this.getContext();
        Queue queue = (Queue)this.getDestination(DESTINATION);
        QueueSender sender = (QueueSender)SessionHelper.createProducer(context.getSession(), null);
        QueueSenderTest.assertEquals((String)"Default time-to-live incorrect for QueueSender created with an anonymous queue", (long)0L, (long)sender.getTimeToLive());
        this.verifySendWithQueue(sender, queue, context.getMessage(), 0L);
        sender.close();
    }

    public void testSetTTL() throws Exception {
        long timeToLive = 50000L;
        TestContext context = this.getContext();
        QueueSender sender = (QueueSender)SessionHelper.createProducer(context.getSession(), this.getDestination(DESTINATION));
        sender.setTimeToLive(50000L);
        QueueSenderTest.assertEquals((String)"Failed to set the time-to-live on QueueSender", (long)50000L, (long)sender.getTimeToLive());
        this.verifySend(sender, context.getMessage(), 50000L);
        sender.close();
    }

    public void testSetTTLWithAnonQueue() throws Exception {
        long timeToLive = 50000L;
        TestContext context = this.getContext();
        Queue queue = (Queue)this.getDestination(DESTINATION);
        QueueSender sender = (QueueSender)SessionHelper.createProducer(context.getSession(), null);
        sender.setTimeToLive(50000L);
        QueueSenderTest.assertEquals((String)"Failed to set the time-to-live on QueueSender with an anonymous destination", (long)50000L, (long)sender.getTimeToLive());
        this.verifySendWithQueue(sender, queue, context.getMessage(), 50000L);
        sender.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendWithTTL() throws Exception {
        long timeToLive = 50000L;
        TestContext context = this.getContext();
        Message message = context.getMessage();
        int deliveryMode = context.getMessagingBehaviour().getDeliveryMode();
        QueueSender sender = (QueueSender)SessionHelper.createProducer(context.getSession(), this.getDestination(DESTINATION));
        MessageReceiver receiver = this.createReceiver(DESTINATION);
        try {
            long start = System.currentTimeMillis();
            sender.send(message, deliveryMode, 1, 50000L);
            long end = System.currentTimeMillis();
            this.checkExpiration(message, start, end, 50000L);
            this.checkSameExpiration(message, receiver);
        }
        finally {
            this.close(receiver);
            sender.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendWithTTLAndAnonQueue() throws Exception {
        long timeToLive = 50000L;
        TestContext context = this.getContext();
        Message message = context.getMessage();
        int deliveryMode = context.getMessagingBehaviour().getDeliveryMode();
        Queue queue = (Queue)this.getDestination(DESTINATION);
        QueueSender sender = (QueueSender)SessionHelper.createProducer(context.getSession(), null);
        MessageReceiver receiver = this.createReceiver(DESTINATION);
        try {
            long start = System.currentTimeMillis();
            sender.send(queue, message, deliveryMode, 1, 50000L);
            long end = System.currentTimeMillis();
            this.checkExpiration(message, start, end, 50000L);
            this.checkSameExpiration(message, receiver);
        }
        finally {
            this.close(receiver);
            sender.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifySend(QueueSender sender, Message message, long timeToLive) throws Exception {
        MessageReceiver receiver = this.createReceiver(DESTINATION);
        try {
            long start = System.currentTimeMillis();
            sender.send(message);
            long end = System.currentTimeMillis();
            this.checkExpiration(message, start, end, timeToLive);
            this.checkSameExpiration(message, receiver);
        }
        finally {
            this.close(receiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifySendWithQueue(QueueSender sender, Queue queue, Message message, long timeToLive) throws Exception {
        MessageReceiver receiver = this.createReceiver(DESTINATION);
        try {
            long start = System.currentTimeMillis();
            sender.send(queue, message);
            long end = System.currentTimeMillis();
            this.checkExpiration(message, start, end, timeToLive);
            this.checkSameExpiration(message, receiver);
        }
        finally {
            this.close(receiver);
        }
    }
}

