/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.producer.ttl;

import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import junit.framework.Test;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.SessionHelper;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.producer.ttl.TimeToLiveTestCase;

public class TopicPublisherTest
extends TimeToLiveTestCase {
    private static final String DESTINATION = "TopicPublisherTest";
    private static final long TTL = 50000L;

    public TopicPublisherTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(TopicPublisherTest.class);
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    public void testDefaultTTL() throws Exception {
        long timeToLive = 0L;
        TestContext context = this.getContext();
        TopicPublisher publisher = (TopicPublisher)SessionHelper.createProducer(context.getSession(), this.getDestination(DESTINATION));
        TopicPublisherTest.assertEquals((String)"Default time-to-live incorrect for TopicPublisher", (long)0L, (long)publisher.getTimeToLive());
        this.verifyPublish(publisher, context.getMessage(), 0L);
        publisher.close();
    }

    public void testDefaultTTLForAnonTopic() throws Exception {
        long timeToLive = 0L;
        TestContext context = this.getContext();
        Topic topic = (Topic)this.getDestination(DESTINATION);
        TopicPublisher publisher = (TopicPublisher)SessionHelper.createProducer(context.getSession(), null);
        TopicPublisherTest.assertEquals((String)"Default time-to-live incorrect for TopicPublisher created with an anonymous topic", (long)0L, (long)publisher.getTimeToLive());
        this.verifyPublishWithTopic(publisher, topic, context.getMessage(), 0L);
        publisher.close();
    }

    public void testSetTTL() throws Exception {
        long timeToLive = 50000L;
        TestContext context = this.getContext();
        TopicPublisher publisher = (TopicPublisher)SessionHelper.createProducer(context.getSession(), this.getDestination(DESTINATION));
        publisher.setTimeToLive(50000L);
        TopicPublisherTest.assertEquals((String)"Failed to set the time-to-live on TopicPublisher", (long)50000L, (long)publisher.getTimeToLive());
        this.verifyPublish(publisher, context.getMessage(), 50000L);
        publisher.close();
    }

    public void testSetTTLWithAnonTopic() throws Exception {
        long timeToLive = 50000L;
        TestContext context = this.getContext();
        Topic topic = (Topic)this.getDestination(DESTINATION);
        TopicPublisher publisher = (TopicPublisher)SessionHelper.createProducer(context.getSession(), null);
        publisher.setTimeToLive(50000L);
        TopicPublisherTest.assertEquals((String)"Failed to set the time-to-live on TopicPublisher with an anonymous destination", (long)50000L, (long)publisher.getTimeToLive());
        this.verifyPublishWithTopic(publisher, topic, context.getMessage(), 50000L);
        publisher.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPublishWithTTL() throws Exception {
        long timeToLive = 50000L;
        TestContext context = this.getContext();
        Message message = context.getMessage();
        int deliveryMode = context.getMessagingBehaviour().getDeliveryMode();
        TopicPublisher publisher = (TopicPublisher)SessionHelper.createProducer(context.getSession(), this.getDestination(DESTINATION));
        MessageReceiver receiver = this.createReceiver(DESTINATION);
        try {
            long start = System.currentTimeMillis();
            publisher.publish(message, deliveryMode, 1, 50000L);
            long end = System.currentTimeMillis();
            this.checkExpiration(message, start, end, 50000L);
            this.checkSameExpiration(message, receiver);
        }
        finally {
            this.close(receiver);
            publisher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPublishWithTTLAndAnonTopic() throws Exception {
        long timeToLive = 50000L;
        TestContext context = this.getContext();
        Message message = context.getMessage();
        int deliveryMode = context.getMessagingBehaviour().getDeliveryMode();
        Topic topic = (Topic)this.getDestination(DESTINATION);
        TopicPublisher publisher = (TopicPublisher)SessionHelper.createProducer(context.getSession(), null);
        MessageReceiver receiver = this.createReceiver(DESTINATION);
        try {
            long start = System.currentTimeMillis();
            publisher.publish(topic, message, deliveryMode, 1, 50000L);
            long end = System.currentTimeMillis();
            this.checkExpiration(message, start, end, 50000L);
            this.checkSameExpiration(message, receiver);
        }
        finally {
            this.close(receiver);
            publisher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyPublish(TopicPublisher publisher, Message message, long timeToLive) throws Exception {
        MessageReceiver receiver = this.createReceiver(DESTINATION);
        try {
            long start = System.currentTimeMillis();
            publisher.publish(message);
            long end = System.currentTimeMillis();
            this.checkExpiration(message, start, end, timeToLive);
            this.checkSameExpiration(message, receiver);
        }
        finally {
            this.close(receiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyPublishWithTopic(TopicPublisher publisher, Topic topic, Message message, long timeToLive) throws Exception {
        MessageReceiver receiver = this.createReceiver(DESTINATION);
        try {
            long start = System.currentTimeMillis();
            publisher.publish(topic, message);
            long end = System.currentTimeMillis();
            this.checkExpiration(message, start, end, timeToLive);
            this.checkSameExpiration(message, receiver);
        }
        finally {
            this.close(receiver);
        }
    }
}

