/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.selector;

import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.InvalidSelectorException;
import javax.jms.Message;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessagingHelper;
import org.exolab.jmscts.core.PropertyPopulator;
import org.exolab.jmscts.core.SessionHelper;
import org.exolab.jmscts.core.TestContext;

public abstract class AbstractSelectorTestCase
extends AbstractSendReceiveTestCase {
    private static final String DESTINATION = "SelectorTest";

    public AbstractSelectorTestCase(String name) {
        super(name);
    }

    public MessagePopulator getMessagePopulator() {
        return null;
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    protected void checkSelector(String selector, boolean selectsAll) throws Exception {
        this.checkSelector(selector, selectsAll, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSelector(String selector, boolean selectsAll, Map properties) throws Exception {
        int count = 5;
        TestContext context = this.getContext();
        Message message = context.getMessage();
        Destination destination = this.getDestination(DESTINATION);
        MessageReceiver receiver = null;
        try {
            int received;
            receiver = SessionHelper.createReceiver(context, destination, selector, false);
            if (properties != null) {
                PropertyPopulator populator = new PropertyPopulator(properties);
                populator.populate(message);
            }
            MessagingHelper.send(context, message, destination, 5);
            int expected = selectsAll ? 5 : 0;
            long timeout = context.getMessagingBehaviour().getTimeout();
            List result = receiver.receive(expected, timeout);
            int n = received = result == null ? 0 : result.size();
            if (received != expected) {
                AbstractSelectorTestCase.fail((String)("Expected " + expected + " messages for selector=\"" + selector + "\" but got " + received));
            }
        }
        catch (InvalidSelectorException exception) {
            AbstractSelectorTestCase.fail((String)("InvalidSelectorException thrown for valid selector=\"" + selector + "\""));
        }
        finally {
            if (receiver != null) {
                receiver.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkInvalidSelector(String selector) throws Exception {
        TestContext context = this.getContext();
        Destination destination = this.getDestination(DESTINATION);
        MessageReceiver receiver = null;
        try {
            receiver = SessionHelper.createReceiver(context, destination, selector, false);
            AbstractSelectorTestCase.fail((String)("Expected InvalidSelectorException to be thrown for selector=\"" + selector + "\""));
        }
        catch (InvalidSelectorException expected) {
        }
        catch (Exception exception) {
            String message = "Expected InvalidSelectorException to be thrown for selector=\"" + selector + "\", but threw " + exception.getClass().getName() + ", message=" + exception.getMessage() + " instead";
            AbstractSelectorTestCase.fail((String)message);
        }
        finally {
            if (receiver != null) {
                receiver.remove();
            }
        }
    }
}

