/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.selector;

import java.util.HashMap;
import junit.framework.Test;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.selector.AbstractSelectorTestCase;

public class BetweenOperatorTest
extends AbstractSelectorTestCase {
    private static final HashMap PROPERTIES = new HashMap();

    public BetweenOperatorTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(BetweenOperatorTest.class);
    }

    public void testBetween1() throws Exception {
        this.checkSelector("17 between 16 and 18", true);
    }

    public void testBetween2() throws Exception {
        this.checkSelector("17 between 18 and 19", false);
    }

    public void testBetween3() throws Exception {
        this.checkSelector("17 Between 17 And 17", true);
    }

    public void testBetween4() throws Exception {
        this.checkSelector("17 between 4 * 4 and 10 + 8", true);
    }

    public void testBetween5() throws Exception {
        this.checkSelector("17 between 4 * 5 and 10 + 12", false);
    }

    public void testBetween6() throws Exception {
        this.checkSelector("two between one and three", true, PROPERTIES);
    }

    public void testNotBetween1() throws Exception {
        this.checkSelector("17 not between 18 and 19", true);
    }

    public void testNotBetween2() throws Exception {
        this.checkSelector("17 not between 16 and 18", false);
    }

    public void testNotBetween3() throws Exception {
        this.checkSelector("17 NOT between 17 and 17", false);
    }

    public void testNotBetween4() throws Exception {
        this.checkSelector("17 Not Between 4 * 5 And 20 / 1", true);
    }

    public void testNotBetween5() throws Exception {
        this.checkSelector("two not between one and three", false, PROPERTIES);
    }

    public void testUnsetProperty1() throws Exception {
        this.checkSelector("dummy between 1 and 10", false);
    }

    public void testUnsetProperty2() throws Exception {
        this.checkSelector("1 between dummy and 10", false);
    }

    public void testUnsetProperty3() throws Exception {
        this.checkSelector("1 between 0 and dummy", false);
    }

    public void testInvalid1() throws Exception {
        this.checkInvalidSelector("two between '1' and '3'");
    }

    public void testInvalid2() throws Exception {
        this.checkInvalidSelector("one between false and true");
    }

    public void testInvalid3() throws Exception {
        this.checkInvalidSelector("'b' between 'a' and 'c'");
    }

    public void testInvalid4() throws Exception {
        this.checkInvalidSelector("between 1 and 3");
    }

    public void testInvalid5() throws Exception {
        this.checkInvalidSelector("not between 1 and 3");
    }

    public void testInvalid6() throws Exception {
        this.checkInvalidSelector("2 between 1, 3");
    }

    public void testInvalid7() throws Exception {
        this.checkInvalidSelector("2 between 1 and");
    }

    public void testInvalid8() throws Exception {
        this.checkInvalidSelector("2 between and 3");
    }

    public void testInvalid9() throws Exception {
        this.checkInvalidSelector("JMSMessageID between 1 and 10");
    }

    static {
        PROPERTIES.put("one", new Integer(1));
        PROPERTIES.put("two", new Integer(2));
        PROPERTIES.put("three", new Integer(3));
    }
}

