/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.selector;

import java.util.HashMap;
import junit.framework.Test;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.selector.AbstractSelectorTestCase;

public class FloatTest
extends AbstractSelectorTestCase {
    private static final HashMap PROPERTIES = new HashMap();

    public FloatTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(FloatTest.class);
    }

    public void testEquals1() throws Exception {
        this.checkSelector("0.0 = 0.0", true);
    }

    public void testEquals2() throws Exception {
        this.checkSelector("0.0 = 1.0", false);
    }

    public void testEquals3() throws Exception {
        this.checkSelector("0.2 = 0.2", true);
    }

    public void testEquals4() throws Exception {
        this.checkSelector("0.2 = 0.0", false);
    }

    public void testEquals5() throws Exception {
        this.checkSelector("92d = 92", true);
    }

    public void testEquals6() throws Exception {
        this.checkSelector("93f = 93", true);
    }

    public void testNotEquals1() throws Exception {
        this.checkSelector("1.0 <> 2.0", true);
    }

    public void testNotEquals2() throws Exception {
        this.checkSelector("1.0 <> 1.0", false);
    }

    public void testNotEquals3() throws Exception {
        this.checkSelector("1.0 <> 1.1", true);
    }

    public void testLessThan1() throws Exception {
        this.checkSelector("1.0 < 2.0", true);
    }

    public void testLessThan2() throws Exception {
        this.checkSelector("2.0 < 1.0", false);
    }

    public void testGreaterThan1() throws Exception {
        this.checkSelector("2.0 > 1.0", true);
    }

    public void testGreaterThan2() throws Exception {
        this.checkSelector("1.0 > 2.0", false);
    }

    public void testLessEquals1() throws Exception {
        this.checkSelector("1.0 <= 2.0", true);
    }

    public void testLessEquals2() throws Exception {
        this.checkSelector("2.0 <= 1.0", false);
    }

    public void testGreaterEquals1() throws Exception {
        this.checkSelector("2.0 >= 1.0", true);
    }

    public void testGreaterEquals2() throws Exception {
        this.checkSelector("1.0 >= 2.0", false);
    }

    public void testUnaryMinus1() throws Exception {
        this.checkSelector("-1.0 = -1.0", true);
    }

    public void testUnaryMinus2() throws Exception {
        this.checkSelector("-1.0 = 1.0", false);
    }

    public void testUnaryMinus3() throws Exception {
        this.checkSelector("--1.0 = 1.0", true);
    }

    public void testEqualsProperty() throws Exception {
        this.checkSelector("rate = 0.2", true, PROPERTIES);
    }

    public void testNotEqualsProperty() throws Exception {
        this.checkSelector("rate <> 0.2", false, PROPERTIES);
    }

    public void testUnsetProperty1() throws Exception {
        this.checkSelector("dummy + 10.0 = 10.0", false);
    }

    public void testUnsetProperty2() throws Exception {
        this.checkSelector("dummy - 10.0 = -10.0", false);
    }

    public void testUnsetProperty3() throws Exception {
        this.checkSelector("10.0 + dummy = 10.0", false);
    }

    public void testUnsetProperty4() throws Exception {
        this.checkSelector("10.0 - dummy = 0.0", false);
    }

    public void testUnsetProperty5() throws Exception {
        this.checkSelector("dummy * 10.0 = 0.0", false);
    }

    public void testUnsetProperty6() throws Exception {
        this.checkSelector("10.0 * dummy = 0.0", false);
    }

    public void testUnsetProperty7() throws Exception {
        this.checkSelector("dummy / 10.0 = 1.0", false);
    }

    public void testUnsetProperty8() throws Exception {
        this.checkSelector("10.0 / dummy = 1.0", false);
    }

    public void testNumericRange() throws Exception {
        this.checkSelector("4.9E-324=4.9E-324 and 1.7976931348623157E308=1.7976931348623157E308", true);
    }

    public void testDivisionByZero() throws Exception {
        this.checkSelector("10.0 / zero = 10.0 / zero", true, PROPERTIES);
    }

    public void testFloatNaN1() throws Exception {
        this.checkSelector("floatNaN = floatNaN", false, PROPERTIES);
    }

    public void testFloatNaN2() throws Exception {
        this.checkSelector("floatNaN <> floatNaN", true, PROPERTIES);
    }

    public void testDoubleNaN1() throws Exception {
        this.checkSelector("doubleNaN = doubleNaN", false, PROPERTIES);
    }

    public void testDoubleNaN2() throws Exception {
        this.checkSelector("doubleNaN <> doubleNaN", true, PROPERTIES);
    }

    public void testInvalid1() throws Exception {
        this.checkInvalidSelector("1.0");
    }

    public void testInvalid2() throws Exception {
        this.checkInvalidSelector("-1.0");
    }

    public void testInvalid3() throws Exception {
        this.checkInvalidSelector("2.0 < '3.0'");
    }

    public void testInvalid4() throws Exception {
        this.checkInvalidSelector("1.0 <> false");
    }

    public void testInvalid5() throws Exception {
        this.checkInvalidSelector("1a.0 = 1a.0");
    }

    static {
        double rate = 0.2;
        PROPERTIES.put("rate", new Double(0.2));
        PROPERTIES.put("zero", new Double(0.0));
        PROPERTIES.put("floatNaN", new Float(Float.NaN));
        PROPERTIES.put("doubleNaN", new Double(Double.NaN));
    }
}

