/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.session;

import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import junit.framework.Test;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.DelayedAction;
import org.exolab.jmscts.core.EchoListener;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.MessagingBehaviour;
import org.exolab.jmscts.core.SessionHelper;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestContextHelper;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.core.WaitingListener;

public class ListenerCloseTest
extends AbstractSendReceiveTestCase {
    private static final String REQUEST = "requestClose";
    private static final String REPLY = "replyClose";
    private static final String[] DESTINATIONS = new String[]{"requestClose", "replyClose"};
    private static final Category log = Category.getInstance((Class)ListenerCloseTest.class);

    public ListenerCloseTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(ListenerCloseTest.class);
    }

    public boolean share() {
        return false;
    }

    public boolean startConnection() {
        return false;
    }

    public String[] getDestinations() {
        return DESTINATIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSessionClose() throws Exception {
        int count = 10;
        long delayTime = 500L;
        TestContext context = this.getContext();
        Session session = context.getSession();
        MessagingBehaviour behaviour = context.getMessagingBehaviour();
        boolean durable = behaviour.getDurable();
        Destination request = this.getDestination(REQUEST);
        TestContext local = TestContextHelper.createSendReceiveContext(context);
        MessageReceiver receiver = this.createReceiver(local, REPLY);
        MessageConsumer consumer = null;
        try {
            String name = durable ? SessionHelper.getSubscriberName() : null;
            consumer = SessionHelper.createConsumer(context, request, name);
            MessageSender sender = this.createSender(context, REPLY);
            EchoListener replier = new EchoListener(context.getSession(), sender, 10, true);
            final WaitingListener listener = new WaitingListener(replier, 1);
            consumer.setMessageListener((MessageListener)listener);
            this.send(request, 1);
            context.getConnection().start();
            log.debug((Object)"waiting for listener");
            listener.waitForReceipt();
            log.debug((Object)"notifying listener");
            DelayedAction action = new DelayedAction(500L){

                public void runProtected() {
                    listener.notifyContinue();
                }
            };
            action.start();
            session.close();
        }
        finally {
            try {
                consumer.close();
            }
            catch (Exception exception) {
                ListenerCloseTest.fail((String)("Attempting to invoke close() for a consumer on a closed session threw exception=" + exception.getClass().getName() + ", message=" + exception.getMessage()));
            }
        }
        try {
            local.getConnection().start();
            this.receive(receiver, 10);
        }
        finally {
            receiver.remove();
            local.getConnection().close();
        }
    }
}

