/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.session.clientack;

import java.util.Iterator;
import java.util.List;
import javax.jms.Message;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.SequencePropertyPopulator;
import org.exolab.jmscts.core.TestContext;

abstract class ClientAcknowledgeTestCase
extends AbstractSendReceiveTestCase {
    private static final Category log = Category.getInstance((Class)ClientAcknowledgeTestCase.class);

    public ClientAcknowledgeTestCase(String name) {
        super(name);
    }

    protected void send(int count) throws Exception {
        this.send(this.getContext(), count);
    }

    protected void send(TestContext context, int count) throws Exception {
        Message message = context.getMessage();
        String[] destinations = this.getDestinations();
        for (int i = 0; i < destinations.length; ++i) {
            String name = destinations[i];
            MessageSender sender = this.createSender(name);
            String group = name;
            SequencePropertyPopulator populator = new SequencePropertyPopulator(group);
            sender.send(message, count, populator);
            sender.close();
        }
    }

    protected Message receive(MessageReceiver[] receivers, int count, int sequence, boolean redelivered) throws Exception {
        return this.receive(this.getContext(), receivers, count, sequence, redelivered);
    }

    protected Message receive(TestContext context, MessageReceiver[] receivers, int count, int sequence, boolean redelivered) throws Exception {
        Message last = null;
        for (int i = 0; i < receivers.length; ++i) {
            List messages = this.receive(context, receivers[i], count);
            String name = this.getDestinations()[i];
            this.checkProperties(messages, name, sequence, redelivered);
            last = (Message)messages.get(count - 1);
        }
        return last;
    }

    protected void checkProperties(List messages, String group, int sequence, boolean redelivered) throws Exception {
        String groupProperty = "JMSXGroupID";
        String seqProperty = "JMSXGroupSeq";
        Iterator iter = messages.iterator();
        while (iter.hasNext()) {
            int seqValue;
            Message message = (Message)iter.next();
            String groupValue = message.getStringProperty(groupProperty);
            if (!group.equals(groupValue)) {
                String msg = "Expected " + groupProperty + "=" + group + " but got " + groupValue;
                ClientAcknowledgeTestCase.fail((String)msg);
            }
            if (sequence != (seqValue = message.getIntProperty(seqProperty))) {
                String msg = "Expected " + seqProperty + "=" + sequence + " but got " + seqValue;
                ClientAcknowledgeTestCase.fail((String)msg);
            }
            ++sequence;
            if (message.getJMSRedelivered() == redelivered) continue;
            ClientAcknowledgeTestCase.fail((String)("Expected message to have JMSRedelivered=" + redelivered + ", but got JMSRedelivered=" + message.getJMSRedelivered()));
        }
    }
}

