/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.session.clientack;

import javax.jms.Session;
import junit.framework.Test;
import org.exolab.jmscts.core.ConnectionHelper;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestContextHelper;
import org.exolab.jmscts.core.TestCreator;
import org.exolab.jmscts.test.session.clientack.ClientAcknowledgeTestCase;

public class CloseTest
extends ClientAcknowledgeTestCase {
    private static final String[] DESTINATIONS = new String[]{"clientack1", "clientack2", "clientack3"};

    public CloseTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(CloseTest.class);
    }

    public String[] getDestinations() {
        return DESTINATIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectionClose() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        MessageReceiver[] receivers = this.createReceivers(context);
        TestContext context2 = TestContextHelper.createSendReceiveContext(context);
        MessageReceiver[] receivers2 = this.createReceivers(context2);
        try {
            context.getConnection().start();
            context2.getConnection().start();
            this.send(context2, 10);
            this.receive(context2, receivers2, 10, 1, false);
            this.close(receivers2);
            boolean redelivered = context.isQueueConnectionFactory();
            context2.getConnection().close();
            this.receive(receivers, 10, 1, redelivered);
        }
        finally {
            this.close(receivers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSessionClose() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        MessageReceiver[] receivers = this.createReceivers(context);
        Session session2 = ConnectionHelper.createSession(context);
        TestContext parent = new TestContext(context, session2, context.getAckType());
        TestContext context2 = new TestContext(parent, context.getMessage(), context.getMessagingBehaviour());
        MessageReceiver[] receivers2 = this.createReceivers(context2);
        try {
            this.send(context2, 10);
            this.receive(context2, receivers2, 10, 1, false);
            this.close(receivers2);
            boolean redelivered = context.isQueueConnectionFactory();
            session2.close();
            this.receive(receivers, 10, 1, redelivered);
        }
        finally {
            this.close(receivers);
        }
    }
}

