/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.session.clientack;

import java.util.Iterator;
import java.util.List;
import javax.jms.Message;
import javax.jms.Session;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.AckTypes;
import org.exolab.jmscts.core.JMSTestRunner;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestContextHelper;
import org.exolab.jmscts.core.TestCreator;

public class SubscriberRedeliveredTest
extends AbstractSendReceiveTestCase {
    private static final String DESTINATION = "SubscriberRedeliveredTest";
    private static final Category log = Category.getInstance((Class)SubscriberRedeliveredTest.class);

    public SubscriberRedeliveredTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        JMSTestRunner test = new JMSTestRunner(SubscriberRedeliveredTest.suite(), args);
        TestRunner.run((Test)test);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(SubscriberRedeliveredTest.class);
    }

    public String[] getDestinations() {
        return new String[]{DESTINATION};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJMSRedelivered() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        Session session = context.getSession();
        TestContext clientAckContext = TestContextHelper.createSessionContext(context, AckTypes.CLIENT_ACKNOWLEDGE);
        Session clientAckSession = clientAckContext.getSession();
        MessageReceiver subscriber1 = null;
        MessageReceiver subscriber2 = null;
        try {
            subscriber1 = this.createReceiver(context, DESTINATION);
            subscriber2 = this.createReceiver(clientAckContext, DESTINATION);
            this.send(context, DESTINATION, 10);
            List messages = this.receive(clientAckContext, subscriber2, 10);
            this.checkJMSRedelivered(messages, false);
            clientAckSession.recover();
            messages = this.receive(clientAckContext, subscriber2, 10);
            this.checkJMSRedelivered(messages, true);
            messages = this.receive(context, subscriber1, 10);
            this.checkJMSRedelivered(messages, false);
        }
        catch (Throwable throwable) {
            this.close(subscriber1);
            this.close(subscriber2);
            throw throwable;
        }
        this.close(subscriber1);
        this.close(subscriber2);
    }

    protected void checkJMSRedelivered(List messages, boolean redelivered) throws Exception {
        Iterator iter = messages.iterator();
        while (iter.hasNext()) {
            Message message = (Message)iter.next();
            if (message.getJMSRedelivered() == redelivered) continue;
            SubscriberRedeliveredTest.fail((String)("Expected message to have JMSRedelivered=" + redelivered + ", but got JMSRedelivered=" + message.getJMSRedelivered()));
        }
    }
}

