/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.session.transacted;

import javax.jms.Message;
import javax.jms.Session;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.ConnectionHelper;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestContextHelper;
import org.exolab.jmscts.core.TestCreator;

public class CloseTest
extends AbstractSendReceiveTestCase {
    private static final String[] DESTINATIONS = new String[]{"rollback1", "rollback2", "rollback3"};

    public CloseTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(CloseTest.class);
    }

    public String[] getDestinations() {
        return DESTINATIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRollbackForClosedSession() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        Message message = context.getMessage();
        Session session = ConnectionHelper.createSession(context);
        TestContext tmp = new TestContext(context, session, context.getAckType());
        TestContext local = new TestContext(tmp, context.getMessage(), context.getMessagingBehaviour());
        MessageSender[] senders = this.createSenders(local);
        MessageReceiver[] receivers = this.createReceivers(context);
        try {
            this.send(senders, message, 10);
            session.close();
            this.receive(receivers, 0);
        }
        finally {
            this.close(senders);
            this.close(receivers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRollbackForClosedConnection() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        Message message = context.getMessage();
        TestContext local = TestContextHelper.createSendReceiveContext(context);
        MessageSender[] senders = this.createSenders(local);
        MessageReceiver[] receivers = this.createReceivers(context);
        try {
            this.send(senders, message, 10);
            local.getConnection().close();
            this.receive(receivers, 0);
        }
        finally {
            this.close(senders);
            this.close(receivers);
        }
    }
}

