/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.session.transacted;

import javax.jms.Message;
import javax.jms.Session;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class CommitTest
extends AbstractSendReceiveTestCase {
    private static final String[] DESTINATIONS = new String[]{"commit1", "commit2", "commit3"};

    public CommitTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(CommitTest.class);
    }

    public String[] getDestinations() {
        return DESTINATIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCommit() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        Session session = context.getSession();
        Message message = context.getMessage();
        MessageSender[] senders = this.createSenders();
        MessageReceiver[] receivers = this.createReceivers();
        try {
            this.send(senders, message, 10);
            this.receive(receivers, 0);
            session.commit();
            this.receive(receivers, 10);
        }
        finally {
            this.close(senders);
            this.close(receivers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCommitForClosedEndpoint() throws Exception {
        int count = 10;
        TestContext context = this.getContext();
        Session session = context.getSession();
        Message message = context.getMessage();
        MessageSender[] senders = this.createSenders();
        MessageReceiver[] receivers = this.createReceivers();
        try {
            this.send(senders, message, 10);
            this.close(senders);
            session.commit();
            this.receive(receivers, 10);
            this.close(receivers);
            session.commit();
            if (context.isQueueConnectionFactory()) {
                receivers = this.createReceivers();
                this.receive(receivers, 0);
            }
        }
        finally {
            this.close(senders);
            this.close(receivers);
        }
    }
}

