/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.test.topic;

import javax.jms.Destination;
import javax.jms.Session;
import javax.jms.TopicSession;
import junit.framework.Test;
import org.exolab.jmscts.core.AbstractSendReceiveTestCase;
import org.exolab.jmscts.core.MessageReceiver;
import org.exolab.jmscts.core.MessagingHelper;
import org.exolab.jmscts.core.SessionHelper;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestCreator;

public class DurableSubscriberTest
extends AbstractSendReceiveTestCase {
    private static final String[] DESTINATIONS = new String[]{"DurableSubscriberTest1", "DurableSubscriberTest2"};

    public DurableSubscriberTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestCreator.createSendReceiveTest(DurableSubscriberTest.class);
    }

    public String[] getDestinations() {
        return DESTINATIONS;
    }

    public void testDurableSubscriber() throws Exception {
        String name = "durableSubscriber";
        int count = 10;
        TestContext context = this.getContext();
        Destination destination = this.getDestination(DESTINATIONS[0]);
        Session session = context.getSession();
        MessageReceiver subscriber = null;
        subscriber = SessionHelper.createReceiver(context, destination, "durableSubscriber", null, false);
        MessagingHelper.send(context, destination, 10);
        subscriber.close();
        subscriber = SessionHelper.createReceiver(context, destination, "durableSubscriber", null, false);
        MessagingHelper.receive(context, subscriber, 10);
        if (session.getTransacted()) {
            session.commit();
        }
        subscriber.remove();
    }

    public void testChangeSubscription() throws Exception {
        String name = "changeSubscription";
        int count = 10;
        TestContext context = this.getContext();
        Destination destination1 = this.getDestination(DESTINATIONS[0]);
        Destination destination2 = this.getDestination(DESTINATIONS[1]);
        Session session = context.getSession();
        MessageReceiver subscriber = null;
        subscriber = SessionHelper.createReceiver(context, destination1, "changeSubscription", null, false);
        MessagingHelper.send(context, destination1, 10);
        subscriber.close();
        subscriber = SessionHelper.createReceiver(context, destination2, "changeSubscription", null, false);
        MessagingHelper.receive(context, subscriber, 0);
        MessagingHelper.send(context, destination2, 10);
        MessagingHelper.receive(context, subscriber, 10);
        if (session.getTransacted()) {
            session.commit();
        }
        subscriber.remove();
    }

    public void testUnsubscribe() throws Exception {
        String name = "unsubscribe";
        int count = 10;
        TestContext context = this.getContext();
        TopicSession session = (TopicSession)context.getSession();
        Destination destination = this.getDestination(DESTINATIONS[0]);
        MessageReceiver subscriber = null;
        subscriber = SessionHelper.createReceiver(context, destination, "unsubscribe", null, false);
        MessagingHelper.send(context, destination, 10);
        subscriber.close();
        try {
            session.unsubscribe("unsubscribe");
        }
        catch (Exception exception) {
            DurableSubscriberTest.fail((String)"Failed to unsubscribe durable subscriber");
        }
        subscriber = SessionHelper.createReceiver(context, destination, "unsubscribe", null, false);
        subscriber.remove();
    }
}

