/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.tools;

import java.util.Enumeration;
import java.util.Iterator;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.NamingException;
import org.apache.log4j.Category;
import org.exolab.jmscts.core.TestContext;
import org.exolab.jmscts.core.TestStatistics;
import org.exolab.jmscts.provider.Administrator;
import org.exolab.jmscts.provider.Configuration;
import org.exolab.jmscts.provider.ProviderLoader;

public abstract class MessagingTool {
    private String _path;
    private String _factoryName;
    private String _destName;
    private ProviderLoader _provider;
    private Administrator _admin;
    private TestContext _context;
    private Destination _destination;
    private int _count;
    private boolean _verbose = false;
    private static final Category log = Category.getInstance((Class)MessagingTool.class);

    public void setConfig(String path) {
        this._path = path;
    }

    public void setConnectionFactory(String name) {
        this._factoryName = name;
    }

    public void setDestination(String name) {
        this._destName = name;
    }

    public void setCount(int count) {
        this._count = count;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    public void invoke() throws Exception {
        this.initialise();
        this.doInvoke();
    }

    protected abstract void doInvoke() throws Exception;

    protected void initialise() throws Exception {
        Configuration config = Configuration.read(this._path);
        Iterator iterator = config.getProviders().iterator();
        this._provider = (ProviderLoader)iterator.next();
        this._provider.getProvider().initialise(false);
        this._admin = this._provider.getProvider().getAdministrator();
        this._destination = (Destination)this._admin.lookup(this._destName);
        Class factoryClass = null;
        ConnectionFactory factory = null;
        if (this._factoryName == null) {
            factory = this.getDefaultConnectionFactory(this._destination);
            factoryClass = this.getDefaultConnectionFactoryType(this._destination);
        } else {
            factory = this.getConnectionFactory(this._factoryName);
            factoryClass = this.getConnectionFactoryType(factory);
        }
        TestContext rootContext = new TestContext(new TestStatistics());
        TestContext providerContext = new TestContext(rootContext, this._admin);
        this._context = new TestContext(providerContext, factory, factoryClass);
    }

    protected TestContext getContext() {
        return this._context;
    }

    protected Destination getDestination() {
        return this._destination;
    }

    protected int getCount() {
        return this._count;
    }

    protected void log(Message message) {
        String messageId = null;
        String mode = null;
        StringBuffer properties = new StringBuffer();
        try {
            messageId = message.getJMSMessageID();
            mode = message.getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON_PERSISTENT";
        }
        catch (JMSException exception) {
            log.error((Object)exception);
        }
        System.out.println(messageId + " " + mode);
        if (this._verbose) {
            try {
                Enumeration iterator = message.getPropertyNames();
                while (iterator.hasMoreElements()) {
                    String name = (String)iterator.nextElement();
                    Object object = message.getObjectProperty(name);
                    System.out.println(" " + name + "=" + object);
                }
            }
            catch (JMSException exception) {
                log.error((Object)exception);
            }
        }
    }

    private ConnectionFactory getConnectionFactory(String name) throws NamingException {
        return (ConnectionFactory)this._admin.lookup(name);
    }

    private Class getConnectionFactoryType(ConnectionFactory factory) {
        Class result;
        if (factory instanceof XAQueueConnectionFactory) {
            result = XAQueueConnectionFactory.class;
        } else if (factory instanceof QueueConnectionFactory) {
            result = QueueConnectionFactory.class;
        } else if (factory instanceof XATopicConnectionFactory) {
            result = XATopicConnectionFactory.class;
        } else if (factory instanceof TopicConnectionFactory) {
            result = TopicConnectionFactory.class;
        } else {
            throw new IllegalArgumentException("Unsupported connection factory: " + factory);
        }
        return result;
    }

    private ConnectionFactory getDefaultConnectionFactory(Destination destination) throws NamingException {
        String name;
        if (destination instanceof Queue) {
            name = this._admin.getQueueConnectionFactory();
        } else if (destination instanceof Topic) {
            name = this._admin.getTopicConnectionFactory();
        } else {
            throw new IllegalArgumentException("Unsupported destination: " + destination);
        }
        return this.getConnectionFactory(name);
    }

    private Class getDefaultConnectionFactoryType(Destination destination) {
        Class result;
        if (destination instanceof Queue) {
            result = QueueConnectionFactory.class;
        } else if (destination instanceof Topic) {
            result = TopicConnectionFactory.class;
        } else {
            throw new IllegalArgumentException("Unsupported destination: " + destination);
        }
        return result;
    }
}

