/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.tools.send;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.exolab.jmscts.core.DeliveryType;
import org.exolab.jmscts.tools.MessagingCommand;
import org.exolab.jmscts.tools.MessagingTool;
import org.exolab.jmscts.tools.send.Send;

public class Main
extends MessagingCommand {
    protected MessagingTool create() {
        return new Send();
    }

    protected Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withArgName((String)"mode");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the delivery mode. One of PERSISTENT or NON_PERSISTENT. Defaults to PERSISTENT");
        Option delivery = OptionBuilder.create((String)"mode");
        options.addOption(delivery);
        return options;
    }

    protected String getUsage() {
        return "usage: send [-config <path>] [-f <name>] [-mode <mode>] -d <name> -c <number> [-v]";
    }

    protected void parse(MessagingTool tool, CommandLine commands) throws ParseException {
        super.parse(tool, commands);
        Send send = (Send)tool;
        send.setDeliveryType(Main.getDeliveryType(commands));
    }

    private static DeliveryType getDeliveryType(CommandLine commands) throws ParseException {
        DeliveryType delivery = null;
        String mode = commands.getOptionValue("mode", "PERSISTENT");
        if (mode.equals("PERSISTENT")) {
            delivery = new DeliveryType(true, true);
        } else if (mode.equals("NON_PERSISTENT")) {
            delivery = new DeliveryType(false, true);
        } else {
            throw new ParseException("Invalid delivery mode: " + mode);
        }
        return delivery;
    }

    public static void main(String[] args) throws Exception {
        Main command = new Main();
        command.invoke(args);
    }
}

