/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.exolab.jmscts.core.MessagePopulator;

public abstract class AbstractMessagePopulator
implements MessagePopulator {
    public void populate(Message message) throws Exception {
        if (message instanceof BytesMessage) {
            this.populateBytesMessage((BytesMessage)message);
        } else if (message instanceof MapMessage) {
            this.populateMapMessage((MapMessage)message);
        } else if (message instanceof ObjectMessage) {
            this.populateObjectMessage((ObjectMessage)message);
        } else if (message instanceof StreamMessage) {
            this.populateStreamMessage((StreamMessage)message);
        } else if (message instanceof TextMessage) {
            this.populateTextMessage((TextMessage)message);
        } else {
            this.populateMessage(message);
        }
    }

    public void populateMessage(Message message) throws Exception {
        throw new UnsupportedOperationException("populateMessage() not implemented by " + this.getClass().getName());
    }

    public void populateBytesMessage(BytesMessage message) throws Exception {
        throw new UnsupportedOperationException("populateBytesMessage() not implemented by " + this.getClass().getName());
    }

    public void populateMapMessage(MapMessage message) throws Exception {
        throw new UnsupportedOperationException("populateMapMessage() not implemented by " + this.getClass().getName());
    }

    public void populateObjectMessage(ObjectMessage message) throws Exception {
        throw new UnsupportedOperationException("populateObjectMessage() not implemented by " + this.getClass().getName());
    }

    public void populateStreamMessage(StreamMessage message) throws Exception {
        throw new UnsupportedOperationException("populateStreamMessage() not implemented by " + this.getClass().getName());
    }

    public void populateTextMessage(TextMessage message) throws Exception {
        throw new UnsupportedOperationException("populateTextMessage() not implemented by " + this.getClass().getName());
    }
}

