/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.QueueReceiver;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.exolab.jmscts.core.MessageReceiver;

abstract class AbstractMessageReceiver
implements MessageReceiver {
    private Session _session = null;
    private MessageConsumer _consumer = null;
    private String _name = null;

    public AbstractMessageReceiver(Session session, MessageConsumer consumer, String name) {
        if (session == null) {
            throw new IllegalArgumentException("Argument session is null");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("Argument consumer is null");
        }
        this._session = session;
        this._consumer = consumer;
        this._name = name;
    }

    public Destination getDestination() throws JMSException {
        Object result = null;
        result = this._consumer instanceof QueueReceiver ? ((QueueReceiver)this._consumer).getQueue() : ((TopicSubscriber)this._consumer).getTopic();
        return result;
    }

    public String getSelector() throws JMSException {
        return this._consumer.getMessageSelector();
    }

    public String getName() {
        return this._name;
    }

    public boolean getNoLocal() throws JMSException {
        boolean result = false;
        if (this._consumer instanceof TopicSubscriber) {
            result = ((TopicSubscriber)this._consumer).getNoLocal();
        }
        return result;
    }

    public void close() throws JMSException {
        if (this._consumer != null) {
            this._consumer.close();
            this._consumer = null;
        }
    }

    public void remove() throws JMSException {
        this.close();
        if (this._name != null && this._session instanceof TopicSession) {
            ((TopicSession)this._session).unsubscribe(this._name);
        }
    }

    protected MessageConsumer getConsumer() {
        return this._consumer;
    }
}

