/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.QueueSender;
import javax.jms.TopicPublisher;
import org.exolab.jmscts.core.MessagePopulator;
import org.exolab.jmscts.core.MessageSender;
import org.exolab.jmscts.core.MessagingBehaviour;

abstract class AbstractMessageSender
implements MessageSender {
    private MessageProducer _producer = null;
    private MessagingBehaviour _behaviour = null;

    public AbstractMessageSender(MessageProducer producer, MessagingBehaviour behaviour) {
        if (producer == null) {
            throw new IllegalArgumentException("Argument producer is null");
        }
        if (behaviour == null) {
            throw new IllegalArgumentException("Argument behaviour is null");
        }
        this._producer = producer;
        this._behaviour = behaviour;
    }

    public void send(Message message, int count) throws JMSException {
        this.send(message, count, null, this.getProducer().getTimeToLive());
    }

    public void send(Message message, int count, long timeToLive) throws JMSException {
        this.send(message, count, null, timeToLive);
    }

    public void send(Message message, int count, MessagePopulator populator) throws JMSException {
        this.send(message, count, populator, this.getProducer().getTimeToLive());
    }

    public Destination getDestination() throws JMSException {
        Object result = null;
        result = this._producer instanceof QueueSender ? ((QueueSender)this._producer).getQueue() : ((TopicPublisher)this._producer).getTopic();
        return result;
    }

    public void close() throws JMSException {
        if (this._producer != null) {
            this._producer.close();
            this._producer = null;
        }
    }

    protected MessageProducer getProducer() {
        return this._producer;
    }

    protected MessagingBehaviour getBehaviour() {
        return this._behaviour;
    }
}

