/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jmscts.core;

import java.util.Arrays;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.exolab.jmscts.core.MessageVerifier;
import org.exolab.jmscts.core.MethodCache;
import org.exolab.jmscts.core.MethodInvoker;

public abstract class AbstractMessageVerifier
implements MessageVerifier {
    private Class _exception = null;
    private MethodInvoker _invoker = null;

    public AbstractMessageVerifier() {
        this._invoker = new MethodInvoker();
    }

    public AbstractMessageVerifier(Class exception) {
        this._exception = exception;
        this._invoker = new MethodInvoker(null, this._exception);
    }

    public void verify(Message message) throws Exception {
        if (message instanceof BytesMessage) {
            this.verifyBytesMessage((BytesMessage)message);
        } else if (message instanceof MapMessage) {
            this.verifyMapMessage((MapMessage)message);
        } else if (message instanceof ObjectMessage) {
            this.verifyObjectMessage((ObjectMessage)message);
        } else if (message instanceof StreamMessage) {
            this.verifyStreamMessage((StreamMessage)message);
        } else if (message instanceof TextMessage) {
            this.verifyTextMessage((TextMessage)message);
        } else {
            this.verifyMessage(message);
        }
    }

    public void verifyMessage(Message message) throws Exception {
        throw new UnsupportedOperationException("verifyMessage() not implemented by " + this.getClass().getName());
    }

    public void verifyBytesMessage(BytesMessage message) throws Exception {
        throw new UnsupportedOperationException("verifyBytesMessage() not implemented by " + this.getClass().getName());
    }

    public void verifyMapMessage(MapMessage message) throws Exception {
        throw new UnsupportedOperationException("verifyMapMessage() not implemented by " + this.getClass().getName());
    }

    public void verifyObjectMessage(ObjectMessage message) throws Exception {
        throw new UnsupportedOperationException("verifyObjectMessage() not implemented by " + this.getClass().getName());
    }

    public void verifyStreamMessage(StreamMessage message) throws Exception {
        throw new UnsupportedOperationException("verifyStreamMessage() not implemented by " + this.getClass().getName());
    }

    public void verifyTextMessage(TextMessage message) throws Exception {
        throw new UnsupportedOperationException("verifyTextMessage() not implemented by " + this.getClass().getName());
    }

    public Class getExpectedException() {
        return this._exception;
    }

    protected Object invoke(Message message, String method) throws Exception {
        MethodCache cache = this.getMethods();
        Object result = null;
        result = cache != null ? this._invoker.invoke((Object)message, cache.getMethod(method)) : this._invoker.invoke((Object)message, method);
        return result;
    }

    protected Object invoke(Message message, String method, Object value) throws Exception {
        MethodCache cache = this.getMethods();
        Object result = null;
        result = cache != null ? this._invoker.invoke((Object)message, cache.getMethod(method, 1), value) : this._invoker.invoke((Object)message, method, value);
        return result;
    }

    protected Object invoke(Message message, String method, Object[] values) throws Exception {
        MethodCache cache = this.getMethods();
        Object result = cache != null ? this._invoker.invoke((Object)message, cache.getMethod(method, values.length), values) : this._invoker.invoke((Object)message, method, values);
        return result;
    }

    protected void expect(Message message, String method, Object expected) throws Exception {
        this.equal(this.invoke(message, method), expected);
    }

    protected void expect(Message message, String method, Object value, Object expected) throws Exception {
        this.equal(this.invoke(message, method, value), expected);
    }

    protected void expect(Message message, String method, Object[] values, Object expected) throws Exception {
        this.equal(this.invoke(message, method, values), expected);
    }

    protected void equal(Object value, Object expected) throws Exception {
        if (expected != null || value != null) {
            if (expected == null || value == null) {
                throw new Exception("Expected value=" + expected + ", but got value=" + value);
            }
            if (expected.getClass() == value.getClass()) {
                if (expected instanceof byte[]) {
                    if (!Arrays.equals((byte[])expected, (byte[])value)) {
                        throw new Exception("Byte arrays are not equal");
                    }
                } else if (!expected.equals(value)) {
                    throw new Exception("Expected value=" + expected + ", but got value=" + value);
                }
            } else {
                throw new Exception("Class mismatch. Expected class=" + expected.getClass().getName() + ", but got class=" + value.getClass().getName());
            }
        }
    }

    protected MethodCache getMethods() {
        return null;
    }
}

